/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.core.registration;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.registrations.Classes;
import ch.njol.util.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.bukkit.event.Cancellable;
import us.tlatoani.tablisknu.core.base.Logging;
import us.tlatoani.tablisknu.core.registration.Documentation;
import us.tlatoani.tablisknu.core.registration.DocumentationElement;

public interface DocumentationBuilder<D extends DocumentationElement, B extends DocumentationBuilder<D, B>> {
    public D build();

    public B document(String var1, String var2, String ... var3);

    public B requiredPlugins(String ... var1);

    public B example(String ... var1);

    public static Effect effect(String category, String[] syntaxes) {
        return new Effect(category, syntaxes);
    }

    public static Condition condition(String category, String[] syntaxes) {
        return new Condition(category, syntaxes, null);
    }

    public static Expression expression(String category, String[] syntaxes, Class returnType) {
        return new Expression(category, syntaxes, returnType, null);
    }

    public static Event event(String category, String[] syntaxes, boolean cancellable) {
        return new Event(category, syntaxes, cancellable);
    }

    public static Scope scope(String category, String[] syntaxes) {
        return new Scope(category, syntaxes);
    }

    public static class Scope
    extends Abstract<DocumentationElement.Scope, Scope> {
        public Scope(String category, String[] syntaxes) {
            super(category, syntaxes);
        }

        @Override
        public DocumentationElement.Scope build() {
            return new DocumentationElement.Scope(this.name, this.category, this.syntaxes, this.description, this.originVersion, this.requiredPlugins, this.examples);
        }
    }

    public static class EventValue {
        private Class type;
        private String description = null;
        private String originVersion = null;

        public EventValue(Class type, String originVersion, String description) {
            this.type = type;
            this.description = description;
            this.originVersion = originVersion;
        }

        public DocumentationElement.EventValue build(DocumentationElement.Event parent) {
            ClassInfo classInfo = Classes.getExactClassInfo((Class)this.type);
            return new DocumentationElement.EventValue(parent, classInfo == null ? this.type.getName() : classInfo.getCodeName(), this.description, this.originVersion);
        }
    }

    public static class Event
    extends Abstract<DocumentationElement.Event, Event> {
        private boolean cancellable;
        private List<EventValue> eventValueBuilders = new LinkedList<EventValue>();

        public Event(String category, String[] syntaxes, boolean cancellable) {
            super(category, syntaxes);
            this.cancellable = cancellable;
        }

        public Event(String category, String[] syntaxes, Class<? extends org.bukkit.event.Event> event) {
            this(category, syntaxes, Cancellable.class.isAssignableFrom(event));
        }

        @Override
        public DocumentationElement.Event build() {
            return new DocumentationElement.Event(this.name, this.category, this.syntaxes, this.description, this.originVersion, this.requiredPlugins, this.examples, this.cancellable, this.eventValueBuilders);
        }

        public Event eventValue(Class type, String originVersion, String description) {
            this.eventValueBuilders.add(new EventValue(type, originVersion, description));
            return this;
        }
    }

    public static class Changer {
        private Changer.ChangeMode mode;
        private Class type;
        private String description = null;
        private String originVersion = null;

        public Changer(Changer.ChangeMode mode, Class type, String originVersion, String description) {
            this.mode = mode;
            this.type = type;
            this.description = description;
            this.originVersion = originVersion;
        }

        public DocumentationElement.Changer build(DocumentationElement parent) {
            boolean single;
            ClassInfo classInfo;
            if (this.type == null) {
                classInfo = null;
                single = false;
            } else if (this.type.getComponentType() != null) {
                classInfo = Classes.getExactClassInfo(this.type.getComponentType());
                single = false;
            } else {
                classInfo = Classes.getExactClassInfo((Class)this.type);
                single = true;
            }
            Optional<Pair<ClassInfo, Boolean>> typeDoc = classInfo == null ? Optional.empty() : Optional.of(new Pair((Object)classInfo, (Object)single));
            return new DocumentationElement.Changer(parent, this.mode, typeDoc, this.description, this.originVersion);
        }
    }

    public static class Expression
    extends Changeable<DocumentationElement.Expression, Expression> {
        private ClassInfo returnType;

        public Expression(String category, String[] syntaxes, Class returnType, Class<? extends ch.njol.skript.lang.Expression> exprClass) {
            super(category, syntaxes, exprClass);
            this.returnType = Classes.getExactClassInfo((Class)returnType);
        }

        @Override
        public DocumentationElement.Expression build() {
            if (this.exprClass != null) {
                this.addChangers(this.exprClass);
            }
            return new DocumentationElement.Expression(this.name, this.category, this.syntaxes, this.description, this.originVersion, this.returnType, this.requiredPlugins, (List<String[]>)this.examples, this.changerBuilders);
        }
    }

    public static class Condition
    extends Changeable<DocumentationElement.Condition, Condition> {
        public Condition(String category, String[] syntaxes, Class<? extends ch.njol.skript.lang.Expression> exprClass) {
            super(category, syntaxes, exprClass);
        }

        @Override
        public DocumentationElement.Condition build() {
            if (this.exprClass != null) {
                this.addChangers(this.exprClass);
            }
            return new DocumentationElement.Condition(this.name, this.category, this.syntaxes, this.description, this.originVersion, this.requiredPlugins, this.examples, this.changerBuilders);
        }
    }

    public static class Effect
    extends Abstract<DocumentationElement.Effect, Effect> {
        public Effect(String category, String[] syntaxes) {
            super(category, syntaxes);
        }

        @Override
        public DocumentationElement.Effect build() {
            return new DocumentationElement.Effect(this.name, this.category, this.syntaxes, this.description, this.originVersion, this.requiredPlugins, this.examples);
        }
    }

    public static abstract class Changeable<D extends DocumentationElement, B extends Changeable<D, B>>
    extends Abstract<D, B> {
        protected Class<? extends ch.njol.skript.lang.Expression> exprClass;
        protected List<Changer> changerBuilders = new ArrayList<Changer>();

        Changeable(String category, String[] syntaxes, Class<? extends ch.njol.skript.lang.Expression> exprClass) {
            super(category, syntaxes);
            this.exprClass = exprClass;
        }

        protected void addChangers(Class<? extends ch.njol.skript.lang.Expression> exprClass) {
            try {
                ch.njol.skript.lang.Expression expr = exprClass.newInstance();
                for (Changer.ChangeMode mode : Changer.ChangeMode.values()) {
                    Class[] changeTypes = expr.acceptChange(mode);
                    if (changeTypes == null) continue;
                    if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
                        if (this.containsChanger(mode, null)) continue;
                        this.changerBuilders.add(new Changer(mode, null, this.originVersion, ""));
                        continue;
                    }
                    for (Class changeType : changeTypes) {
                        if (changeType == null || this.containsChanger(mode, changeType)) continue;
                        this.changerBuilders.add(new Changer(mode, changeType, this.originVersion, ""));
                    }
                }
            }
            catch (Exception e) {
                Logging.debug((Object)this, e);
            }
        }

        protected boolean containsChanger(Changer.ChangeMode mode, Class type) {
            for (Changer changer : this.changerBuilders) {
                if (changer.mode != mode || changer.type != type) continue;
                return true;
            }
            return false;
        }

        public B changer(Changer.ChangeMode mode, Class type, String originVersion, String description) {
            if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
                throw new IllegalArgumentException("Illegal ChangeMode: " + mode);
            }
            this.changerBuilders.add(new Changer(mode, type, originVersion, description));
            return (B)this;
        }

        public B changer(Changer.ChangeMode mode, String originVersion, String description) {
            if (mode != Changer.ChangeMode.RESET && mode != Changer.ChangeMode.DELETE) {
                throw new IllegalArgumentException("Illegal ChangeMode: " + mode);
            }
            this.changerBuilders.add(new Changer(mode, null, originVersion, description));
            return (B)this;
        }

        @Override
        public B document(String name, String originVersion, String ... description) {
            super.document(name, originVersion, description);
            return (B)this;
        }
    }

    public static abstract class Abstract<D extends DocumentationElement, B extends Abstract<D, B>>
    implements DocumentationBuilder<D, B> {
        protected String name = null;
        protected String category = null;
        public String[] syntaxes = null;
        protected String[] description = null;
        protected String originVersion = null;
        protected String[] requiredPlugins = null;
        protected List<String[]> examples = new LinkedList<String[]>();

        Abstract(String category, String[] syntaxes) {
            this.category = category;
            this.syntaxes = syntaxes;
        }

        @Override
        public B document(String name, String originVersion, String ... description) {
            Documentation.addBuilder(this);
            this.name = name;
            this.description = description;
            this.originVersion = originVersion;
            return (B)this;
        }

        @Override
        public B requiredPlugins(String ... plugins) {
            this.requiredPlugins = plugins;
            return (B)this;
        }

        @Override
        public B example(String ... example) {
            this.examples.add(example);
            return (B)this;
        }
    }
}

