/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.blueprint;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.event.Event;
import us.tlatoani.tablisknu.blueprint.ARGBColor;
import us.tlatoani.tablisknu.blueprint.Blueprint;

public class ExprColorOfPixel
extends SimpleExpression<ARGBColor> {
    private Expression<Blueprint> blueprintExpression;
    private Expression<Number> xExpression;
    private Expression<Number> yExpression;

    protected ARGBColor[] get(Event event) {
        Blueprint blueprint = (Blueprint)this.blueprintExpression.getSingle(event);
        if (blueprint == null) {
            return new ARGBColor[0];
        }
        int x = ((Number)this.xExpression.getSingle(event)).intValue();
        int y = ((Number)this.yExpression.getSingle(event)).intValue();
        return new ARGBColor[]{blueprint.getPixelColor(x, y)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ARGBColor> getReturnType() {
        return ARGBColor.class;
    }

    public String toString(Event e, boolean debug) {
        return "color of pixel " + this.xExpression + ", " + this.yExpression + " of " + this.blueprintExpression;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.xExpression = exprs[0];
        this.yExpression = exprs[1];
        this.blueprintExpression = exprs[2];
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Blueprint blueprint = (Blueprint)this.blueprintExpression.getSingle(event);
        if (blueprint == null) {
            return;
        }
        int x = ((Number)this.xExpression.getSingle(event)).intValue();
        int y = ((Number)this.yExpression.getSingle(event)).intValue();
        ARGBColor color = mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE ? ARGBColor.TRANSPARENT : (ARGBColor)delta[0];
        blueprint.colorPixel(x, y, color);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        switch (mode) {
            case SET: {
                return (Class[])CollectionUtils.array((Object[])new Class[]{ARGBColor.class});
            }
            case RESET: 
            case DELETE: {
                return (Class[])CollectionUtils.array((Object[])new Class[0]);
            }
        }
        return null;
    }
}

