/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.blueprint;

import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.yggdrasil.Fields;
import java.awt.image.BufferedImage;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.StringJoiner;
import org.bukkit.Color;
import us.tlatoani.tablisknu.blueprint.ARGBColor;
import us.tlatoani.tablisknu.blueprint.Blueprint;
import us.tlatoani.tablisknu.blueprint.EffColorBlueprint;
import us.tlatoani.tablisknu.blueprint.EffCreateBlueprint;
import us.tlatoani.tablisknu.blueprint.EffOverlayBlueprint;
import us.tlatoani.tablisknu.blueprint.EffRecolorBlueprint;
import us.tlatoani.tablisknu.blueprint.ExprBlankBlueprint;
import us.tlatoani.tablisknu.blueprint.ExprBlueprintCopy;
import us.tlatoani.tablisknu.blueprint.ExprColorOfPixel;
import us.tlatoani.tablisknu.blueprint.ExprFaceOfBlueprint;
import us.tlatoani.tablisknu.blueprint.ExprPartOfBlueprint;
import us.tlatoani.tablisknu.blueprint.ExprRectangleOfBlueprint;
import us.tlatoani.tablisknu.blueprint.Face;
import us.tlatoani.tablisknu.blueprint.FaceBlueprint;
import us.tlatoani.tablisknu.blueprint.Part;
import us.tlatoani.tablisknu.blueprint.PartBlueprint;
import us.tlatoani.tablisknu.core.property_expression.MundoPropertyExpression;
import us.tlatoani.tablisknu.core.reflection.Reflection;
import us.tlatoani.tablisknu.core.registration.Registration;
import us.tlatoani.tablisknu.skin.retrieval.SkinFormat;

public class BlueprintMundo {
    public static void load() {
        Reflection.MethodInvoker toBukkitColorMethod;
        Class<?> skriptColorClass = Reflection.getClass("ch.njol.skript.util.Color");
        final HashMap<ARGBColor, String> colorNames = new HashMap<ARGBColor, String>();
        colorNames.put(ARGBColor.TRANSPARENT, "transparent");
        if (Reflection.classExists("ch.njol.skript.util.SkriptColor")) {
            toBukkitColorMethod = Reflection.getMethod(skriptColorClass, "asBukkitColor", new Class[0]);
            for (Object color2 : (Object[])Reflection.getMethod("ch.njol.skript.util.SkriptColor", "values", new Class[0]).invoke(null, new Object[0])) {
                colorNames.put(ARGBColor.fromBukkit((Color)toBukkitColorMethod.invoke(color2, new Object[0])), color2.toString().toLowerCase());
            }
        } else {
            toBukkitColorMethod = Reflection.getMethod(skriptColorClass, "getBukkitColor", new Class[0]);
            for (Object color2 : (Object[])Reflection.getMethod(skriptColorClass, "values", new Class[0]).invoke(null, new Object[0])) {
                colorNames.put(ARGBColor.fromBukkit((Color)toBukkitColorMethod.invoke(color2, new Object[0])), color2.toString().toLowerCase());
            }
        }
        Registration.registerType(ARGBColor.class, "argb", new String[0]).parser(new Registration.SimpleParser<ARGBColor>(){

            @Override
            public String toString(ARGBColor color, int flags) {
                return colorNames.getOrDefault(color, color.isOpaque() ? "rgb " + color.toHexString().substring(2) : "argb " + color.toHexString());
            }

            public ARGBColor parse(String s, ParseContext context) {
                try {
                    if (s.equals("transparent")) {
                        return ARGBColor.TRANSPARENT;
                    }
                    if (s.startsWith("rgb ") && s.length() == 10) {
                        return ARGBColor.fromRGB(Integer.parseInt(s.substring(4), 16));
                    }
                    if (s.startsWith("argb ") && s.length() == 13) {
                        return new ARGBColor((int)Long.parseLong(s.substring(5), 16));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return null;
            }
        }).serializer((Serializer)new Serializer<ARGBColor>(){

            public Fields serialize(ARGBColor o) {
                Fields fields = new Fields();
                fields.putObject("argb", (Object)o.argb);
                return fields;
            }

            public void deserialize(ARGBColor o, Fields f) {
                throw new UnsupportedOperationException();
            }

            public ARGBColor deserialize(Fields fields) throws StreamCorruptedException {
                return new ARGBColor((Integer)fields.getObject("argb"));
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        });
        Registration.registerConverter(skriptColorClass, ARGBColor.class, color -> ARGBColor.fromBukkit((Color)toBukkitColorMethod.invoke(color, new Object[0])));
        Registration.registerType(Blueprint.class, "blueprint", new String[0]).serializer((Serializer)new Serializer<Blueprint>(){

            public Fields serialize(Blueprint blueprint) throws NotSerializableException {
                Fields fields = new Fields();
                fields.putObject("format", (Object)blueprint.format.ordinal());
                if (blueprint instanceof FaceBlueprint) {
                    FaceBlueprint faceBlueprint = (FaceBlueprint)blueprint;
                    fields.putObject("type", (Object)"face");
                    fields.putObject("part", (Object)faceBlueprint.part.ordinal());
                    fields.putObject("isSecondLayer", (Object)faceBlueprint.isSecondLayer);
                    fields.putObject("face", (Object)faceBlueprint.face.ordinal());
                } else if (blueprint instanceof PartBlueprint) {
                    PartBlueprint partBlueprint = (PartBlueprint)blueprint;
                    fields.putObject("type", (Object)"part");
                    fields.putObject("part", (Object)partBlueprint.part.ordinal());
                    fields.putObject("isSecondLayer", (Object)partBlueprint.isSecondLayer);
                } else {
                    fields.putObject("type", (Object)"default");
                }
                int height = blueprint.bufferedImage.getHeight();
                fields.putObject("height", (Object)height);
                int[] pixels = new int[height * blueprint.bufferedImage.getWidth()];
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = blueprint.getPixelColor((int)(i / height), (int)(i % height)).argb;
                }
                fields.putObject("pixels", (Object)pixels);
                return fields;
            }

            public void deserialize(Blueprint o, Fields f) {
                throw new UnsupportedOperationException();
            }

            public Blueprint deserialize(Fields fields) throws StreamCorruptedException {
                Blueprint blueprint;
                SkinFormat format = SkinFormat.values()[(Integer)fields.getObject("format")];
                int height = (Integer)fields.getObject("height");
                int[] pixels = (int[])fields.getObject("pixels");
                BufferedImage bufferedImage = new BufferedImage(pixels.length / height, height, 2);
                for (int i = 0; i < pixels.length; ++i) {
                    bufferedImage.setRGB(i / height, i % height, pixels[i]);
                }
                if (fields.getObject("type").equals("face")) {
                    Part part = Part.values()[(Integer)fields.getObject("part")];
                    boolean isSecondLayer = (Boolean)fields.getObject("isSecondLayer");
                    Face face = Face.values()[(Integer)fields.getObject("face")];
                    blueprint = new FaceBlueprint(bufferedImage, part, isSecondLayer, face, format);
                } else if (fields.getObject("type").equals("part")) {
                    Part part = Part.values()[(Integer)fields.getObject("part")];
                    boolean isSecondLayer = (Boolean)fields.getObject("isSecondLayer");
                    blueprint = new PartBlueprint(bufferedImage, part, isSecondLayer, format);
                } else {
                    blueprint = new Blueprint(bufferedImage, format);
                }
                return blueprint;
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        });
        Registration.registerEffect(EffColorBlueprint.class, "color %blueprint% as %argb%");
        Registration.registerEffect(EffRecolorBlueprint.class, "recolor %argb% in %blueprint% as %argb%");
        Registration.registerEffect(EffOverlayBlueprint.class, "overlay %blueprint% on %blueprint%");
        MundoPropertyExpression.registerPropertyExpression(ExprBlueprintCopy.class, Blueprint.class, "blueprint", "blueprint copied from %");
        Registration.registerExpression(ExprRectangleOfBlueprint.class, Blueprint.class, ExpressionType.COMBINED, "pixels %number%, %number% to %number%, %number% of %blueprint%");
        Registration.registerExpression(ExprColorOfPixel.class, ARGBColor.class, ExpressionType.COMBINED, "color of pixel %number%, %number% of %blueprint%");
        StringJoiner faceJoiner = new StringJoiner("|", "(", ")");
        for (int i = 1; i <= Face.values().length; ++i) {
            faceJoiner.add(i + "\u00a6" + Face.values()[i - 1].name().toLowerCase().replace("_", " "));
        }
        StringJoiner partJoiner = new StringJoiner("|", "(", ")");
        for (int i = 1; i <= Part.values().length; ++i) {
            partJoiner.add((i << 4) + "\u00a6" + Part.values()[i - 1].name().toLowerCase().replace("_", " "));
        }
        Registration.registerEffect(EffCreateBlueprint.class, "create blueprint of %skin% in %object%", "create [(128\u00a6slim)] [" + partJoiner + " [" + faceJoiner + " face]] blueprint from (0\u00a6file|8\u00a6url) %string% in %object%");
        Registration.registerExpression(ExprBlankBlueprint.class, Blueprint.class, ExpressionType.SIMPLE, "blank [(128\u00a6slim)] [ " + partJoiner + " [" + faceJoiner + " face]] blueprint");
        Registration.registerExpression(ExprPartOfBlueprint.class, Blueprint.class, ExpressionType.PROPERTY, "[(8\u00a6second layer)] " + partJoiner + " [" + faceJoiner + " face] pixels of %blueprint%");
        Registration.registerExpression(ExprFaceOfBlueprint.class, Blueprint.class, ExpressionType.PROPERTY, faceJoiner + " face pixels of %blueprint%");
    }
}

