/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.blueprint;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import us.tlatoani.tablisknu.blueprint.Blueprint;
import us.tlatoani.tablisknu.core.base.Logging;
import us.tlatoani.tablisknu.core.base.Scheduling;
import us.tlatoani.tablisknu.skin.Skin;
import us.tlatoani.tablisknu.skin.retrieval.SkinFormat;

public class BlueprintLoader {
    public static void loadFromFile(String path, SkinFormat format, Consumer<Blueprint> callable) {
        Scheduling.async(() -> {
            try {
                Logging.debug(BlueprintLoader.class, "path = " + path);
                BufferedImage bufferedImage = ImageIO.read(new File(path));
                Logging.debug(BlueprintLoader.class, "bufferedImage = " + bufferedImage);
                Blueprint blueprint = bufferedImage == null ? null : new Blueprint(bufferedImage, format);
                Logging.debug(BlueprintLoader.class, "blueprint = " + blueprint);
                Scheduling.sync(() -> callable.accept(blueprint));
            }
            catch (IOException e) {
                Logging.reportException(BlueprintLoader.class, e);
                Scheduling.sync(() -> callable.accept(null));
            }
        });
    }

    public static void loadFromURL(String path, SkinFormat format, Consumer<Blueprint> callable) {
        Scheduling.async(() -> {
            try {
                Blueprint blueprint = new Blueprint(ImageIO.read(new URL(path)), format);
                Scheduling.sync(() -> callable.accept(blueprint));
            }
            catch (IOException e) {
                Logging.reportException(BlueprintLoader.class, e);
                Scheduling.sync(() -> callable.accept(null));
            }
        });
    }

    public static void loadOfSkin(Skin skin, Consumer<Blueprint> callable) {
        try {
            JSONObject textureJSON = (JSONObject)new JSONParser().parse(new String(Base64.getDecoder().decode(skin.value)));
            JSONObject skinJSON = (JSONObject)((JSONObject)textureJSON.get((Object)"textures")).get((Object)"SKIN");
            if (skinJSON == null) {
                Scheduling.sync(() -> callable.accept(null));
            }
            SkinFormat format = skinJSON.containsKey((Object)"metadata") && ((JSONObject)skinJSON.get((Object)"metadata")).containsKey((Object)"model") && ((JSONObject)skinJSON.get((Object)"metadata")).get((Object)"model").equals("slim") ? SkinFormat.ALEX : SkinFormat.STEVE;
            BlueprintLoader.loadFromURL((String)skinJSON.get((Object)"url"), format, callable);
        }
        catch (ClassCastException | ParseException e) {
            Logging.reportException(BlueprintLoader.class, (Exception)e);
            Scheduling.sync(() -> callable.accept(null));
        }
    }
}

