/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.tablist_array;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.Optional;
import org.bukkit.event.Event;
import us.tlatoani.tablisknu.tablist.ArrayTablist;
import us.tlatoani.tablisknu.tablist.SimpleTablist;
import us.tlatoani.tablisknu.tablist.Tablist;
import us.tlatoani.tablisknu.tablist.TablistProvider;
import us.tlatoani.tablisknu.tablist_general.TablistMundo;

public class ExprDimensionOfArrayTablist
extends SimpleExpression<Number> {
    private TablistProvider tablistProvider;
    private boolean isColumns;

    protected Number[] get(Event event) {
        return (Number[])this.tablistProvider.view(event).map(tablist -> {
            if (tablist.getSupplementaryTablist() instanceof ArrayTablist) {
                ArrayTablist arrayTablist = (ArrayTablist)tablist.getSupplementaryTablist();
                return this.isColumns ? arrayTablist.getColumns() : arrayTablist.getRows();
            }
            return null;
        }).toArray(Number[]::new);
    }

    public boolean isSingle() {
        return this.tablistProvider.isSingle();
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event event, boolean b) {
        return this.tablistProvider.toString("amount of " + (this.isColumns ? "column" : "row") + "s in [%'s] array tablist");
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.tablistProvider = TablistProvider.of(expressions, 0);
        this.isColumns = parseResult.mark == 0;
        TablistMundo.printTablistSyntaxWarning("Using tablist dimensions other than 4 rows and 20 columns", "use the default tablist dimensions of 4 rows and 20 columns");
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        int value = Optional.ofNullable((Number)delta[0]).map(Number::intValue).orElse(0);
        for (Tablist tablist : this.tablistProvider.get(event)) {
            if (tablist.getSupplementaryTablist() instanceof ArrayTablist) {
                ArrayTablist arrayTablist = (ArrayTablist)tablist.getSupplementaryTablist();
                if (this.isColumns) {
                    if (value > 0) {
                        arrayTablist.setColumns(value);
                        continue;
                    }
                    tablist.setSupplementaryTablist(SimpleTablist::new);
                    continue;
                }
                arrayTablist.setRows(value);
                continue;
            }
            if (!this.isColumns || value <= 0) continue;
            tablist.setSupplementaryTablist(ArrayTablist.create(value, 20));
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }
}

