/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.tablist_general;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.bukkit.event.Event;
import us.tlatoani.tablisknu.tablist.Tablist;
import us.tlatoani.tablisknu.tablist.TablistProvider;

public class ExprLineOfHeaderFooter
extends SimpleExpression<String> {
    TablistProvider tablistProvider;
    private Optional<Expression<Number>> lineNumberExpression;
    boolean header;

    protected String[] get(Event event) {
        Integer lineNumber = this.lineNumberExpression.map(expr -> Optional.ofNullable(expr.getSingle(event))).orElse(Optional.of(-1)).map(Number::intValue).orElse(null);
        if (lineNumber == null) {
            return new String[0];
        }
        return (String[])this.tablistProvider.view(event).map(this.header ? Tablist::getHeader : Tablist::getFooter).map(list -> (String)list.get((lineNumber == -1 ? list.size() : lineNumber.intValue()) - 1)).toArray(String[]::new);
    }

    public boolean isSingle() {
        return this.tablistProvider.isSingle();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event event, boolean b) {
        return this.tablistProvider.toString(this.lineNumberExpression.map(expr -> "line " + expr).orElse("last line") + " of tablist " + (this.header ? "header" : "footer") + " [of %]");
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.lineNumberExpression = Optional.ofNullable(expressions[0]);
        this.tablistProvider = TablistProvider.of(expressions, 1);
        this.header = parseResult.mark == 0;
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        String value = delta == null || delta.length == 0 || delta[0] == null ? "" : (String)delta[0];
        Integer lineNumber = this.lineNumberExpression.map(expr -> Optional.ofNullable(expr.getSingle(event))).orElse(Optional.of(-1)).map(Number::intValue).orElse(null);
        if (lineNumber == null) {
            return;
        }
        for (Tablist tablist : this.tablistProvider.get(event)) {
            ImmutableList<String> original;
            ImmutableList<String> immutableList = original = this.header ? tablist.getHeader() : tablist.getFooter();
            if (lineNumber <= original.size()) {
                int ix = (lineNumber == -1 ? original.size() : lineNumber.intValue()) - 1;
                ImmutableList.Builder builder = new ImmutableList.Builder();
                for (int i = 0; i < original.size(); ++i) {
                    if (i == ix) {
                        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
                            builder.add((Object)value);
                            continue;
                        }
                        if (mode != Changer.ChangeMode.ADD) continue;
                        builder.add((Object)((String)original.get(i) + value));
                        continue;
                    }
                    builder.add(original.get(i));
                }
                if (this.header) {
                    tablist.setHeader((ImmutableList<String>)builder.build());
                    continue;
                }
                tablist.setFooter((ImmutableList<String>)builder.build());
                continue;
            }
            if (value.isEmpty()) continue;
            Object[] modified = (String[])original.toArray((Object[])new String[lineNumber.intValue()]);
            for (int i = original.size(); i < lineNumber - 1; ++i) {
                modified[i] = "";
            }
            modified[lineNumber.intValue() - 1] = value;
            if (this.header) {
                tablist.setHeader((ImmutableList<String>)ImmutableList.copyOf((Object[])modified));
                continue;
            }
            tablist.setFooter((ImmutableList<String>)ImmutableList.copyOf((Object[])modified));
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String.class});
        }
        return null;
    }
}

