/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.skin.blueprint;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class SkinBlueprint {
    private final BufferedImage bufferedImage;
    public final boolean slim;

    SkinBlueprint(BufferedImage bufferedImage, boolean slim) {
        if (bufferedImage.getType() == 2) {
            this.bufferedImage = bufferedImage;
        } else {
            this.bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            ((Graphics2D)this.bufferedImage.getGraphics()).drawImage(bufferedImage, null, 0, 0);
        }
        this.slim = slim;
    }

    public SkinBlueprint(boolean slim) {
        this(new BufferedImage(64, 64, 2), slim);
    }

    public SkinBlueprint(Part part, boolean slim) {
        this(new BufferedImage(part.imageWidth(slim), part.imageHeight(), 2), slim);
    }

    public void makeColorTransparent(int color) {
        for (int x = 0; x < this.bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < this.bufferedImage.getHeight(); ++y) {
                if ((this.bufferedImage.getRGB(x, y) & 0xFFFFFF) != color) continue;
                this.bufferedImage.setRGB(x, y, 0);
            }
        }
    }

    public SkinBlueprint getPart(Part part, boolean isSecondLayer) {
        return new SkinBlueprint(isSecondLayer ? this.bufferedImage.getSubimage(part.x, part.y, part.imageWidth(this.slim), part.imageHeight()) : this.bufferedImage.getSubimage(part.x2, part.y2, part.imageWidth(this.slim), part.imageHeight()), this.slim);
    }

    public SkinBlueprint getPartFace(Part part, boolean isSecondLayer, Face face) {
        return new SkinBlueprint(this.bufferedImage.getSubimage((isSecondLayer ? part.x : part.x2) + Face.evaluateFormula(face.relXFormula, part, this.slim), (isSecondLayer ? part.y : part.y2) + Face.evaluateFormula(face.relYFormula, part, this.slim), Face.evaluateFormula(face.imageWidthFormula, part, this.slim), Face.evaluateFormula(face.imageHeightFormula, part, this.slim)), this.slim);
    }

    public void overlay(SkinBlueprint blueprint) {
        ((Graphics2D)this.bufferedImage.getGraphics()).drawImage(this.bufferedImage, null, 0, 0);
    }

    public void write(OutputStream output) throws IOException {
        ImageIO.write((RenderedImage)this.bufferedImage, "png", output);
    }

    public static enum Face {
        FRONT(16, 16, 256, 1),
        BACK(288, 16, 256, 1),
        RIGHT(0, 16, 16, 1),
        LEFT(272, 16, 16, 1),
        TOP(16, 0, 256, 16),
        BOTTOM(272, 0, 256, 16);

        final int relXFormula;
        final int relYFormula;
        final int imageWidthFormula;
        final int imageHeightFormula;

        private Face(int relXFormula, int relYFormula, int imageWidthFormula, int imageHeightFormula) {
            this.relXFormula = relXFormula;
            this.relYFormula = relYFormula;
            this.imageWidthFormula = imageWidthFormula;
            this.imageHeightFormula = imageHeightFormula;
        }

        static int evaluateFormula(int formula, Part part, boolean slim) {
            return (formula >> 8) * (slim ? part.slimLength : part.normalLength) + (formula >> 4 & 0xF) * part.width + (formula & 0xF) * part.height;
        }
    }

    public static enum Part {
        HEAD(0, 0, 32, 0, 8, 8, 8),
        BODY(16, 16, 16, 32, 8, 4, 12),
        RIGHT_ARM(40, 16, 40, 32, 4, 3, 4, 12),
        LEFT_ARM(32, 48, 48, 48, 4, 3, 4, 12),
        RIGHT_LEG(0, 16, 0, 32, 4, 4, 12),
        LEFT_LEG(16, 48, 0, 48, 4, 4, 12);

        public final int x;
        public final int y;
        public final int x2;
        public final int y2;
        public final int normalLength;
        public final int slimLength;
        public final int width;
        public final int height;

        private Part(int x, int y, int x2, int y2, int normalLength, int slimLength, int width, int height) {
            this.x = x;
            this.y = y;
            this.x2 = x2;
            this.y2 = y2;
            this.normalLength = normalLength;
            this.slimLength = slimLength;
            this.width = width;
            this.height = height;
        }

        private Part(int x, int y, int x2, int y2, int length, int width, int height) {
            this(x, y, x2, y2, length, length, width, height);
        }

        public int imageWidth(boolean slim) {
            return ((slim ? this.slimLength : this.normalLength) + this.width) * 2;
        }

        public int imageHeight() {
            return this.width + this.height;
        }
    }
}

