/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.player_head;

import com.comphenix.protocol.wrappers.WrappedGameProfile;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import us.tlatoani.tablisknu.core.reflection.Reflection;
import us.tlatoani.tablisknu.skin.Skin;

public abstract class HeadUtil {
    public static final String DEFAULT_HEAD_OWNER = "MundoSK-Name";
    public static final UUID DEFAULT_UUID = UUID.fromString("10001000-1000-3000-8000-100010001000");
    public static final Reflection.FieldAccessor CRAFT_META_SKULL_PROFILE = Reflection.getField(Reflection.getCraftBukkitClass("inventory.CraftMetaSkull"), "profile", Reflection.getClass("com.mojang.authlib.GameProfile"));
    public static final Reflection.FieldAccessor CRAFT_SKULL_PROFILE = Reflection.getField(Reflection.getCraftBukkitClass("block.CraftSkull"), "profile", Reflection.getClass("com.mojang.authlib.GameProfile"));

    @Nullable
    abstract WrappedGameProfile getGameProfile();

    abstract void setGameProfile(WrappedGameProfile var1);

    public Skin getSkin() {
        WrappedGameProfile gameProfile = this.getGameProfile();
        return gameProfile == null ? Skin.EMPTY : Skin.fromGameProfile(gameProfile);
    }

    public void setSkin(Skin skin) {
        String owner = this.getOwner();
        this.setSkinAndOwner(skin, owner == null ? DEFAULT_HEAD_OWNER : owner);
    }

    public String getOwner() {
        WrappedGameProfile gameProfile = this.getGameProfile();
        return gameProfile == null ? null : gameProfile.getName();
    }

    public void setOwner(String owner) {
        Skin skin = this.getSkin();
        this.setGameProfile(skin == null ? new WrappedGameProfile(DEFAULT_UUID, owner) : skin.toGameProfile(owner));
    }

    public void setSkinAndOwner(Skin skin, String owner) {
        this.setGameProfile(skin.toGameProfile(owner));
    }

    public static ItemStack playerHeadItem() {
        Held heldSkull = new Held();
        return heldSkull.item;
    }

    public static ItemStack playerHeadItem(Skin skin) {
        return HeadUtil.playerHeadItem(skin, DEFAULT_HEAD_OWNER);
    }

    public static ItemStack playerHeadItem(Skin skin, String owner) {
        Held heldSkull = new Held();
        heldSkull.setSkinAndOwner(skin, owner);
        return heldSkull.item;
    }

    public static Optional<Held> from(ItemStack itemStack) {
        if (itemStack.getType() == Material.PLAYER_HEAD) {
            return Optional.of(new Held(itemStack));
        }
        return Optional.empty();
    }

    public static Optional<Placed> from(Block block) {
        if (block.getType() == Material.PLAYER_HEAD || block.getType() == Material.PLAYER_WALL_HEAD) {
            return Optional.of(new Placed(block));
        }
        return Optional.empty();
    }

    public static class Placed
    extends HeadUtil {
        public final Block block;

        private Placed(Block block) {
            this.block = block;
            if (block.getType() != Material.PLAYER_HEAD && block.getType() != Material.PLAYER_WALL_HEAD) {
                throw new IllegalArgumentException("Illegal block type: " + block.getType() + ", should be PLAYER_HEAD or PLAYER_WALL_HEAD");
            }
        }

        private Skull getState() {
            return (Skull)this.block.getState();
        }

        @Override
        WrappedGameProfile getGameProfile() {
            return WrappedGameProfile.fromHandle(CRAFT_SKULL_PROFILE.get(this.getState()));
        }

        @Override
        void setGameProfile(WrappedGameProfile gameProfile) {
            Skull skull = this.getState();
            CRAFT_SKULL_PROFILE.set(skull, gameProfile.getHandle());
            skull.update();
        }
    }

    public static class Held
    extends HeadUtil {
        public final ItemStack item;

        private Held() {
            this(new ItemStack(Material.PLAYER_HEAD));
        }

        private Held(ItemStack item) {
            this.item = item;
            if (item.getType() != Material.PLAYER_HEAD) {
                throw new IllegalArgumentException("Illegal type: " + item.getType() + ", should be PLAYER_HEAD");
            }
        }

        @Override
        WrappedGameProfile getGameProfile() {
            return WrappedGameProfile.fromHandle(CRAFT_META_SKULL_PROFILE.get(this.item.getItemMeta()));
        }

        @Override
        void setGameProfile(WrappedGameProfile gameProfile) {
            ItemMeta skullMeta = this.item.getItemMeta();
            CRAFT_META_SKULL_PROFILE.set(skullMeta, gameProfile.getHandle());
            this.item.setItemMeta(skullMeta);
        }
    }
}

