/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu;

import ch.njol.skript.Skript;
import ch.njol.skript.util.Version;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.MemorySection;
import us.tlatoani.tablisknu.core.base.Config;
import us.tlatoani.tablisknu.core.base.Logging;
import us.tlatoani.tablisknu.core.base.MundoAddon;
import us.tlatoani.tablisknu.core.bstats.bukkit.Metrics;
import us.tlatoani.tablisknu.core.registration.Documentation;
import us.tlatoani.tablisknu.core.registration.Registration;
import us.tlatoani.tablisknu.core.updating.Updating;
import us.tlatoani.tablisknu.player_head.PlayerHeadMundo;
import us.tlatoani.tablisknu.skin.ProfileManager;
import us.tlatoani.tablisknu.skin.SkinMundo;
import us.tlatoani.tablisknu.skin.retrieval.PlayerSkinRetrieval;
import us.tlatoani.tablisknu.tablist.TablistManager;
import us.tlatoani.tablisknu.tablist_array.ArrayTablistMundo;
import us.tlatoani.tablisknu.tablist_general.TablistMundo;
import us.tlatoani.tablisknu.tablist_group.TablistGroupMundo;
import us.tlatoani.tablisknu.tablist_player.PlayerTablistMundo;
import us.tlatoani.tablisknu.tablist_simple.SimpleTablistMundo;

public class Tablisknu
extends MundoAddon {
    public static final Config.Option<Integer> TABLIST_REMOTE_TAB_DELAY_SPAWN = Config.option("tablist_remove_tab_delay_spawn", MemorySection::getInt);
    public static final Config.Option<Integer> TABLIST_REMOTE_TAB_DELAY_RESPAWN = Config.option("tablist_remove_tab_delay_respawn", MemorySection::getInt);
    public static final Config.Option<Integer> TABLIST_ADD_TO_DEFAULT_GROUP_DELAY = Config.option("tablist_add_to_default_group_delay", MemorySection::getInt);
    public static final Config.Option<Boolean> DISPLAY_TABLIST_SYNTAX_WARNING = Config.option("display_tablist_syntax_warning", MemorySection::getBoolean);
    public static final Config.Option<Boolean> ENABLE_OFFLINE_SKIN_CACHE = Config.option("enable_offline_skin_cache", MemorySection::getBoolean);
    public static final Config.Option<Integer> OFFLINE_SKIN_CACHE_EXPIRE_TIME_MINUTES = Config.option("offline_skin_cache_expire_time_minutes", MemorySection::getInt);
    public static final Config.Option<Integer> OFFLINE_SKIN_CACHE_MAX_SIZE = Config.option("offline_skin_cache_max_size", MemorySection::getInt);
    public static final Version MINIMUM_PROTOCOLLIB_VERSION = new Version(new int[]{4, 4});

    public Tablisknu() {
        super("tablisknu", ChatColor.DARK_AQUA, ChatColor.AQUA, ChatColor.GOLD);
        this.link("Metrics", "https://bstats.org/plugin/bukkit/Tablisknu");
    }

    @Override
    public void onEnable() {
        super.onEnable();
        Version protocolLibVersion = new Version(Bukkit.getPluginManager().getPlugin("ProtocolLib").getDescription().getVersion());
        if (protocolLibVersion.isSmallerThan(MINIMUM_PROTOCOLLIB_VERSION)) {
            Logging.info("Your version of ProtocolLib is " + protocolLibVersion);
            Logging.info("Tablisknu requires that you run at least version 4.4 of ProtocolLib");
        }
        Documentation.load();
        Updating.load();
        ProfileManager.load();
        TablistManager.load();
        Registration.register("Skin", SkinMundo::load, new String[0]);
        Registration.register("PlayerHead", PlayerHeadMundo::load, new String[0]);
        Registration.register("Tablist", TablistMundo::load, new String[0]);
        Registration.register("ArrayTablist", ArrayTablistMundo::load, new String[0]);
        Registration.register("TablistGroup", TablistGroupMundo::load, new String[0]);
        Registration.register("SimpleTablist", SimpleTablistMundo::load, new String[0]);
        Registration.register("PlayerTablist", PlayerTablistMundo::load, new String[0]);
    }

    @Override
    public void afterPluginsEnabled() {
        Metrics metrics = new Metrics(this);
        metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> Skript.getVersion().toString()));
    }

    @Override
    public void afterConfigReloaded() {
        PlayerSkinRetrieval.reloadSkinCache();
    }
}

