/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.tablist;

import ch.njol.skript.lang.Expression;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import us.tlatoani.tablisknu.core.util.OptionalUtil;
import us.tlatoani.tablisknu.core.util.SkriptUtil;
import us.tlatoani.tablisknu.tablist.Tablist;
import us.tlatoani.tablisknu.tablist.TablistGroup;
import us.tlatoani.tablisknu.tablist.TablistManager;

public abstract class TablistProvider {
    public abstract Stream<Tablist> view(Event var1);

    public abstract Iterable<Tablist> get(Event var1);

    public abstract boolean check(Event var1, Function<Tablist, Boolean> var2, boolean var3);

    public abstract boolean isSingle();

    public abstract String toString();

    public abstract String toString(String var1);

    public static TablistProvider of(Expression<?>[] expressions, int playerExpressionIndex) {
        if (expressions.length > playerExpressionIndex && expressions[playerExpressionIndex] != null) {
            return new Players(expressions[playerExpressionIndex]);
        }
        if (expressions.length > playerExpressionIndex + 1 && expressions[playerExpressionIndex + 1] != null) {
            return new Group(expressions[playerExpressionIndex + 1]);
        }
        return new Group();
    }

    private static class Group
    extends TablistProvider {
        private final Optional<Expression<String>> expression;

        private Group() {
            this.expression = Optional.empty();
        }

        private Group(Expression<String> expression) {
            this.expression = Optional.of(expression);
        }

        @Override
        public Stream<Tablist> view(Event event) {
            return OptionalUtil.stream(this.getGroup(event).map(TablistGroup::getDummy));
        }

        @Override
        public Iterable<Tablist> get(Event event) {
            return this.getGroup(event).map(Function.identity()).orElse(Collections.emptySet());
        }

        public Optional<TablistGroup> getGroup(Event event) {
            return this.expression.map(expr -> Optional.ofNullable(expr.getSingle(event)).map(TablistManager::getTablistGroup)).orElse(Optional.of(TablistManager.GLOBAL_GROUP));
        }

        @Override
        public String toString() {
            return this.expression.map(expr -> "group" + expr).orElse("global group");
        }

        @Override
        public String toString(String syntax) {
            return this.expression.map(expr -> syntax.replace("[", "").replace("%", this.toString()).replace("]", "")).orElseGet(() -> {
                int sectionOpenIx = syntax.indexOf(91);
                int sectionCloseIx = syntax.indexOf(93);
                sectionCloseIx = sectionCloseIx > 0 ? --sectionCloseIx : ++sectionCloseIx;
                return syntax.substring(0, sectionOpenIx) + syntax.substring(sectionCloseIx + 1);
            });
        }

        @Override
        public boolean check(Event event, Function<Tablist, Boolean> condition, boolean positive) {
            return this.getGroup(event).map(group -> positive == (Boolean)condition.apply(group.getDummy())).orElse(false);
        }

        @Override
        public boolean isSingle() {
            return true;
        }
    }

    private static class TablistOfPlayerIterator
    implements Iterator<Tablist> {
        private final Iterator<? extends Player> playerIterator;
        private Player next = null;

        private TablistOfPlayerIterator(Iterator<? extends Player> playerIterator) {
            this.playerIterator = playerIterator;
        }

        @Override
        public boolean hasNext() {
            while (this.next == null && this.playerIterator.hasNext()) {
                this.next = this.playerIterator.next();
                if (this.next.isOnline()) continue;
                this.next = null;
            }
            return this.next != null;
        }

        @Override
        public Tablist next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Tablist result = TablistManager.getTablistOfPlayer(this.next);
            this.next = null;
            return result;
        }
    }

    private static class Players
    extends TablistProvider {
        private final Expression<Player> expression;

        private Players(Expression<Player> expression) {
            this.expression = expression;
        }

        @Override
        public Stream<Tablist> view(Event event) {
            return Stream.of(this.expression.getArray(event)).map(TablistManager::getTablistOfPlayer);
        }

        @Override
        public Iterable<Tablist> get(Event event) {
            if (this.expression.isSingle()) {
                Player player = (Player)this.expression.getSingle(event);
                if (player == null || !player.isOnline()) {
                    return Collections.emptySet();
                }
                return Collections.singleton(TablistManager.getTablistOfPlayer(player));
            }
            return () -> new TablistOfPlayerIterator(this.expression.iterator(event));
        }

        @Override
        public String toString() {
            return this.expression.toString();
        }

        @Override
        public String toString(String syntax) {
            return syntax.replace("[", "").replace("%", this.toString()).replace("]", "");
        }

        @Override
        public boolean check(Event event, Function<Tablist, Boolean> condition, boolean positive) {
            return SkriptUtil.check(this.expression, event, player -> player.isOnline() && (Boolean)condition.apply(TablistManager.getTablistOfPlayer(player)) != false, positive);
        }

        @Override
        public boolean isSingle() {
            return this.expression.isSingle();
        }
    }
}

