/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.tablist;

import com.comphenix.protocol.wrappers.EnumWrappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import us.tlatoani.tablisknu.Tablisknu;
import us.tlatoani.tablisknu.core.base.Scheduling;
import us.tlatoani.tablisknu.core.util.OptionalUtil;
import us.tlatoani.tablisknu.tablist.PlayerTab;
import us.tlatoani.tablisknu.tablist.Tab;
import us.tlatoani.tablisknu.tablist.Tablist;
import us.tlatoani.tablisknu.util.PacketUtil;

public class PlayerTablist {
    public final Tablist tablist;
    private Optional<Map<Player, Optional<Tab>>> tabs = Optional.of(new HashMap());

    public PlayerTablist(Tablist tablist) {
        this.tablist = tablist;
    }

    public Optional<Tab> getTabIfModified(Player player) {
        return this.tabs.flatMap(map -> Optional.ofNullable(map.computeIfPresent(player, (__, tabOptional) -> {
            if (tabOptional.isPresent() && ((Tab)tabOptional.get()).isDefault()) {
                return null;
            }
            return tabOptional;
        })).orElse(Optional.empty()));
    }

    public Optional<Tab> getTab(Player player) {
        return this.tabs.flatMap(map -> map.computeIfAbsent(player, __ -> Optional.of(new PlayerTab(this, player))));
    }

    public boolean isPlayerVisible(Player player) {
        return this.tabs.map(map -> Optional.ofNullable(map.get(player)).map(Optional::isPresent).orElse(true)).orElse(false);
    }

    public void showPlayer(Player player) {
        if (!this.tabs.isPresent()) {
            this.tabs = Optional.of(new HashMap());
            this.tabs.ifPresent(map -> {
                for (Player player1 : Bukkit.getOnlinePlayers()) {
                    map.put(player1, Optional.empty());
                }
            });
        }
        this.tabs.ifPresent(map -> map.computeIfPresent(player, (__, tabOptional) -> {
            if (!tabOptional.isPresent()) {
                this.tablist.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.ADD_PLAYER), this);
                if (this.tablist.areScoresEnabled()) {
                    this.tablist.sendPacket(PacketUtil.scorePacket(player.getName(), "MundoSK_Tablist", 0, EnumWrappers.ScoreboardAction.CHANGE), this);
                }
                return null;
            }
            return tabOptional;
        }));
    }

    public void hidePlayer(Player player) {
        this.tabs.ifPresent(map -> map.compute(player, (__, tabOptional) -> {
            if (tabOptional == null || tabOptional.isPresent()) {
                this.tablist.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
            }
            return Optional.empty();
        }));
    }

    public boolean arePlayersVisible() {
        return this.tabs.isPresent();
    }

    public void showAllPlayers() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.showPlayer(player);
        }
    }

    public void hideAllPlayers() {
        this.tabs.ifPresent(map -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                Optional playerTabOptional = (Optional)map.get(player);
                if (playerTabOptional != null && !playerTabOptional.isPresent()) continue;
                this.tablist.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this);
            }
            this.tabs = Optional.empty();
        });
    }

    public void clearModifications() {
        OptionalUtil.consume(this.tabs, this::showAllPlayers, map -> {
            this.tabs = Optional.of(new HashMap());
            map.forEach((player, tabOptional) -> OptionalUtil.consume(tabOptional, () -> this.tablist.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.ADD_PLAYER), this), tab -> {
                tab.setDisplayName(null);
                tab.setLatencyBars(null);
                tab.setScore(null);
            }));
            map.clear();
        });
    }

    public void onJoin(Player player) {
        if (!this.tabs.isPresent()) {
            Scheduling.syncDelay(Tablisknu.TABLIST_REMOTE_TAB_DELAY_SPAWN.getCurrentValue(), () -> this.tablist.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), this));
        }
    }

    public void onQuit(Player player) {
        this.tabs.ifPresent(map -> {
            Optional cfr_ignored_0 = (Optional)map.remove(player);
        });
    }

    public void applyChanges(PlayerTablist playerTablist) {
        OptionalUtil.consume(this.tabs, playerTablist::hideAllPlayers, tabMap -> tabMap.forEach((player, tabOptional) -> OptionalUtil.consume(tabOptional, () -> playerTablist.hidePlayer((Player)player), tab -> {
            playerTablist.showPlayer((Player)player);
            tab.applyChanges(playerTablist.getTab((Player)player).get());
        })));
    }
}

