/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.skin.retrieval;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.function.Consumer;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import us.tlatoani.tablisknu.core.base.Logging;
import us.tlatoani.tablisknu.core.base.Scheduling;
import us.tlatoani.tablisknu.core.updating.HTTPClient;
import us.tlatoani.tablisknu.skin.Skin;

public class MineSkinRetrieval {
    public static final String MINESKIN_URL_API = "https://api.mineskin.org/generate/url?url=%s&%s";
    public static final String MINESKIN_UPLOAD_API = "https://api.mineskin.org/generate/upload?%s";

    public static void retrieveFromMineSkinAPI(Source source, String path, SkinFormat skinFormat, int timeoutMillis, Consumer<Skin> callable) {
        Scheduling.async(() -> {
            Skin skin = MineSkinRetrieval.skinFromMineSkinAPI(source, path, skinFormat, timeoutMillis);
            Scheduling.sync(() -> callable.accept(skin));
        });
    }

    private static Skin skinFromMineSkinAPI(Source source, String path, SkinFormat skinFormat, int timeoutMillis) {
        try {
            HTTPClient httpClient = source.httpClient(path, skinFormat).timeout(timeoutMillis);
            int statusCode = httpClient.statusCode();
            if (statusCode != 200) {
                Logging.debug(MineSkinRetrieval.class, "While retrieving skin from " + path + ", status code = " + statusCode + " != 200, aborting");
                return null;
            }
            return MineSkinRetrieval.fromMineSkinInputStream(httpClient.getInput());
        }
        catch (IOException | ClassCastException | NullPointerException | ParseException e) {
            Logging.debug(MineSkinRetrieval.class, "Exception occurred while retrieving skin from " + path);
            Logging.debug(MineSkinRetrieval.class, (Exception)e);
            return null;
        }
    }

    private static Skin fromMineSkinInputStream(InputStream inputStream) throws IOException, ParseException {
        JSONObject jsonObject = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(inputStream));
        JSONObject data = (JSONObject)jsonObject.get((Object)"data");
        JSONObject texture = (JSONObject)data.get((Object)"texture");
        return Skin.fromJSON(texture);
    }

    static enum SkinFormat {
        STEVE(""),
        ALEX("model=slim");

        public final String skinOptions;

        private SkinFormat(String skinOptions) {
            this.skinOptions = skinOptions;
        }
    }

    static enum Source {
        URL{

            @Override
            public HTTPClient httpClient(String path, SkinFormat skinFormat) throws IOException {
                return HTTPClient.url(MineSkinRetrieval.MINESKIN_URL_API, path, skinFormat.skinOptions).method("POST");
            }
        }
        ,
        FILE{

            @Override
            public HTTPClient httpClient(String path, SkinFormat skinFormat) throws IOException {
                return HTTPClient.url(MineSkinRetrieval.MINESKIN_UPLOAD_API, skinFormat.skinOptions).method("POST").uploadFile(path);
            }
        };


        public abstract HTTPClient httpClient(String var1, SkinFormat var2) throws IOException;
    }
}

