/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.skin;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Team;
import us.tlatoani.tablisknu.Tablisknu;
import us.tlatoani.tablisknu.core.base.Logging;
import us.tlatoani.tablisknu.core.base.Scheduling;
import us.tlatoani.tablisknu.core.reflection.Reflection;
import us.tlatoani.tablisknu.packetwrapper.WrapperPlayServerPlayerInfo;
import us.tlatoani.tablisknu.packetwrapper.WrapperPlayServerScoreboardScore;
import us.tlatoani.tablisknu.packetwrapper.WrapperPlayServerScoreboardTeam;
import us.tlatoani.tablisknu.skin.ModifiableProfile;
import us.tlatoani.tablisknu.skin.Skin;
import us.tlatoani.tablisknu.tablist.TablistManager;
import us.tlatoani.tablisknu.util.PacketUtil;
import us.tlatoani.tablisknu.util.WorldLockedLocation;

public class ProfileManager {
    static final Map<Player, ModifiableProfile> profileMap = new HashMap<Player, ModifiableProfile>();
    private static final ArrayList<Player> spawnedPlayers = new ArrayList();
    private static Reflection.MethodInvoker CRAFT_PLAYER_GET_HANDLE = null;
    private static Reflection.MethodInvoker DEDICATED_PLAYER_LIST_MOVE_TO_WORLD = null;
    private static Reflection.MethodInvoker CRAFT_WORLD_GET_HANDLE = null;
    private static Reflection.FieldAccessor WORLD_SERVER_DIMENSION = null;

    public static void load() {
        ProfileManager.loadReflectionStuff();
        ProfileManager.loadPacketEvents();
        Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onQuit(PlayerQuitEvent event) {
                ProfileManager.onQuit(event.getPlayer());
            }
        }, (Plugin)Tablisknu.get());
    }

    private static void loadReflectionStuff() {
        try {
            CRAFT_PLAYER_GET_HANDLE = Reflection.getTypedMethod(Reflection.getCraftBukkitClass("entity.CraftPlayer"), "getHandle", Reflection.getMinecraftClass("EntityPlayer"), new Class[0]);
            DEDICATED_PLAYER_LIST_MOVE_TO_WORLD = Reflection.getMethod(Reflection.getMinecraftClass("DedicatedPlayerList"), "moveToWorld", Reflection.getMinecraftClass("EntityPlayer"), Reflection.getMinecraftClass("DimensionManager"), Boolean.TYPE, Location.class, Boolean.TYPE);
            CRAFT_WORLD_GET_HANDLE = Reflection.getTypedMethod(Reflection.getCraftBukkitClass("CraftWorld"), "getHandle", Reflection.getMinecraftClass("WorldServer"), new Class[0]);
            WORLD_SERVER_DIMENSION = Reflection.getField(Reflection.getMinecraftClass("WorldServer"), "dimension", Reflection.getMinecraftClass("DimensionManager"));
        }
        catch (Exception e) {
            Logging.reportException(ProfileManager.class, e);
        }
    }

    private static void loadPacketEvents() {
        PacketUtil.onPacketEvent(PacketType.Play.Server.PLAYER_INFO, event -> {
            if (!PacketUtil.validatePacketEvent(event)) {
                return;
            }
            Player target = event.getPlayer();
            WrapperPlayServerPlayerInfo packet = new WrapperPlayServerPlayerInfo(event.getPacket());
            if (packet.getAction() == EnumWrappers.PlayerInfoAction.ADD_PLAYER || packet.getAction() == EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME) {
                Logging.debug(ProfileManager.class, "Player Info, target = " + target.getName() + ", action = " + packet.getAction());
                List<PlayerInfoData> oldData = packet.getData();
                ArrayList<PlayerInfoData> newData = new ArrayList<PlayerInfoData>(oldData.size());
                for (PlayerInfoData oldPlayerInfoData : oldData) {
                    String nametag;
                    Player player = Bukkit.getPlayer((UUID)oldPlayerInfoData.getProfile().getUUID());
                    if (player == null) {
                        newData.add(oldPlayerInfoData);
                        continue;
                    }
                    Logging.debug(ProfileManager.class, "Player Info Packet: " + player.getName());
                    if (!spawnedPlayers.contains(player)) {
                        Logging.debug(ProfileManager.class, "New player!");
                        spawnedPlayers.add(player);
                    }
                    Logging.debug(ProfileManager.class, "Old nametag = " + oldPlayerInfoData.getProfile().getName());
                    ModifiableProfile.Specific specificProfile = ProfileManager.getProfile(player).getSpecificProfile(target);
                    WrappedChatComponent displayName = oldPlayerInfoData.getDisplayName();
                    Logging.debug(ProfileManager.class, "Old displayName = " + displayName);
                    if (displayName == null) {
                        String rawDisplayName = Optional.ofNullable(target.getScoreboard()).map(scoreboard -> scoreboard.getEntryTeam(player.getName())).map(team -> team.getPrefix() + player.getName() + team.getSuffix()).orElse(player.getName());
                        displayName = WrappedChatComponent.fromText((String)rawDisplayName);
                        Logging.debug(ProfileManager.class, "New displayName = " + displayName);
                    }
                    if ((nametag = specificProfile.getNametag()).equals(player.getName())) {
                        nametag = oldPlayerInfoData.getProfile().getName();
                    }
                    PlayerInfoData newPlayerInfoData = new PlayerInfoData(oldPlayerInfoData.getProfile().withName(nametag), oldPlayerInfoData.getLatency(), oldPlayerInfoData.getGameMode(), displayName);
                    Logging.debug(ProfileManager.class, "New nametag = " + newPlayerInfoData.getProfile().getName());
                    if (packet.getAction() == EnumWrappers.PlayerInfoAction.ADD_PLAYER) {
                        Skin skin = specificProfile.getDisplayedSkin();
                        Logging.debug(ProfileManager.class, "Skin replacement (may not exist): " + skin);
                        if (skin != null) {
                            newPlayerInfoData.getProfile().getProperties().put((Object)Skin.MULTIMAP_KEY, (Object)skin.toWrappedSignedProperty());
                        }
                    }
                    newData.add(newPlayerInfoData);
                }
                packet.setData(newData);
            }
        });
        PacketUtil.onPacketEvent(PacketType.Play.Server.SCOREBOARD_TEAM, event -> {
            if (!PacketUtil.validatePacketEvent(event)) {
                return;
            }
            Player target = event.getPlayer();
            WrapperPlayServerScoreboardTeam packet = new WrapperPlayServerScoreboardTeam(event.getPacket());
            Logging.debug(ProfileManager.class, "Scoreboard Team Packet");
            if (packet.getMode() == 2) {
                Collection modifiedNames = Optional.ofNullable(target.getScoreboard()).map(scoreboard -> scoreboard.getTeam(packet.getName())).map(Team::getEntries).orElse(Collections.emptySet());
                for (String name : modifiedNames) {
                    Player player = Bukkit.getPlayerExact((String)name);
                    if (player == null || !player.isOnline()) continue;
                    Logging.debug(ProfileManager.class, "Player " + name + ", updating");
                    PacketUtil.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME), ProfileManager.class, target);
                }
            } else if (packet.getMode() == 1) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    PacketUtil.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME), ProfileManager.class, target);
                    Logging.debug(ProfileManager.class, "Player " + player.getName() + ", updating");
                }
            } else {
                List<String> oldNames = packet.getPlayers();
                HashSet<String> newNames = new HashSet<String>(oldNames.size());
                for (String name : oldNames) {
                    newNames.add(name);
                    Player player = Bukkit.getPlayerExact((String)name);
                    if (player == null || !player.isOnline()) continue;
                    ModifiableProfile.Specific specificProfile = ProfileManager.getProfile(player).getSpecificProfile(target);
                    String nameTag = specificProfile.getNametag();
                    if (!name.equals(nameTag)) {
                        newNames.add(nameTag);
                    }
                    Logging.debug(ProfileManager.class, "Player " + name + ", nameTag = " + nameTag);
                    PacketUtil.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.UPDATE_DISPLAY_NAME), ProfileManager.class, target);
                }
                Logging.debug(ProfileManager.class, "oldNames = " + oldNames);
                Logging.debug(ProfileManager.class, "newNames = " + newNames);
                packet.setPlayers(new ArrayList<String>(newNames));
            }
        });
        PacketUtil.onPacketEvent(PacketType.Play.Server.SCOREBOARD_SCORE, event -> {
            if (!PacketUtil.validatePacketEvent(event)) {
                return;
            }
            Player target = event.getPlayer();
            WrapperPlayServerScoreboardScore packet = new WrapperPlayServerScoreboardScore(event.getPacket());
            Optional.ofNullable(packet.getScoreName()).map(Bukkit::getPlayerExact).ifPresent(player -> {
                packet.setScoreName(ProfileManager.getProfile(player).getSpecificProfile(target).getNametag());
                Logging.debug(ProfileManager.class, "Replacing score for player = " + player);
            });
        });
    }

    private static void onQuit(Player player) {
        profileMap.remove(player);
        for (ModifiableProfile generalProfile : profileMap.values()) {
            generalProfile.onQuit(player);
        }
        spawnedPlayers.remove(player);
    }

    public static ModifiableProfile getProfile(Player player) {
        if (player == null || !player.isOnline()) {
            throw new IllegalArgumentException("Player must be non-null and online: " + player);
        }
        return profileMap.computeIfAbsent(player, ModifiableProfile::new);
    }

    static void refreshPlayer(Player player, Player target) {
        if (!spawnedPlayers.contains(player)) {
            return;
        }
        if (player.equals(target)) {
            ProfileManager.respawnPlayer(player);
            return;
        }
        target.hidePlayer((Plugin)Tablisknu.get(), player);
        Scheduling.syncDelay(1, () -> target.showPlayer((Plugin)Tablisknu.get(), player));
        Scheduling.syncDelay(2, () -> {
            if (!TablistManager.getTablistOfPlayer(target).isPlayerVisible(player)) {
                PacketUtil.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), ProfileManager.class, target);
            }
        });
    }

    private static void respawnPlayer(Player player) {
        PacketUtil.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), ProfileManager.class, player);
        PacketUtil.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.ADD_PLAYER), ProfileManager.class, player);
        WorldLockedLocation playerLoc = new WorldLockedLocation(player.getLocation());
        Logging.debug(ProfileManager.class, "playerLoc = " + (Object)((Object)playerLoc));
        try {
            Object worldHandle = CRAFT_WORLD_GET_HANDLE.invoke(player.getWorld(), new Object[0]);
            Object dimensionManager = WORLD_SERVER_DIMENSION.get(worldHandle);
            Logging.debug(ProfileManager.class, "DEDICATED_PLAYER_LIST_MOVE_TO_WORLD: " + DEDICATED_PLAYER_LIST_MOVE_TO_WORLD);
            Logging.debug(ProfileManager.class, "NMS_SERVER: " + DEDICATED_PLAYER_LIST_MOVE_TO_WORLD);
            DEDICATED_PLAYER_LIST_MOVE_TO_WORLD.invoke(Reflection.NMS_SERVER, new Object[]{CRAFT_PLAYER_GET_HANDLE.invoke(player, new Object[0]), dimensionManager, true, playerLoc, true});
        }
        catch (Exception e) {
            Logging.debug(ProfileManager.class, "Failed to make player see his skin change: " + player.getName());
            Logging.reportException(ProfileManager.class, e);
        }
    }
}

