/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.tablist;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.PlayerInfoData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import us.tlatoani.tablisknu.Tablisknu;
import us.tlatoani.tablisknu.core.base.Scheduling;
import us.tlatoani.tablisknu.packetwrapper.WrapperPlayServerNamedEntitySpawn;
import us.tlatoani.tablisknu.packetwrapper.WrapperPlayServerPlayerInfo;
import us.tlatoani.tablisknu.tablist.Tablist;
import us.tlatoani.tablisknu.tablist.TablistGroup;
import us.tlatoani.tablisknu.util.PacketUtil;

public class TablistManager {
    private static final Map<Player, Tablist> tablistMap = new HashMap<Player, Tablist>();
    private static final Map<String, TablistGroup> tablistGroupMap = new HashMap<String, TablistGroup>();
    private static final ArrayList<Player> playersRespawning = new ArrayList();
    public static final TablistGroup GLOBAL_GROUP = new TablistGroup();

    public static Tablist getTablistOfPlayer(Player player) {
        if (player == null || !player.isOnline()) {
            throw new IllegalArgumentException("The player parameter in getTablistOfPlayer(Player player) must be non-null and online, player: " + player);
        }
        return tablistMap.computeIfAbsent(player, Tablist::new);
    }

    public static TablistGroup getTablistGroup(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name parameter in getTablistGroup(Player player) must be non-null, name: " + name);
        }
        return tablistGroupMap.computeIfAbsent(name, __ -> new TablistGroup());
    }

    public static boolean deleteTablistGroup(String name) {
        if (name == null) {
            throw new IllegalArgumentException("The name parameter in getTablistGroup(Player player) must be non-null, name: " + name);
        }
        TablistGroup group = tablistGroupMap.remove(name);
        if (group != null) {
            group.reset();
        }
        return group != null;
    }

    public static void load() {
        Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onJoin(PlayerJoinEvent event) {
                TablistManager.onJoin(event.getPlayer());
            }
        }, (Plugin)Tablisknu.get());
        Bukkit.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public void onQuit(PlayerQuitEvent event) {
                TablistManager.onQuit(event.getPlayer());
            }
        }, (Plugin)Tablisknu.get());
        TablistManager.loadPacketEventListeners();
    }

    private static void onJoin(Player player) {
        tablistMap.forEach((__, tablist) -> tablist.onJoin(player));
        Scheduling.syncDelay(Tablisknu.TABLIST_ADD_TO_DEFAULT_GROUP_DELAY.getCurrentValue(), () -> GLOBAL_GROUP.add(player));
    }

    private static void onQuit(Player player) {
        tablistMap.remove(player);
        tablistMap.forEach((__, tablist) -> tablist.onQuit(player));
        GLOBAL_GROUP.remove(player);
        tablistGroupMap.forEach((__, group) -> group.remove(player));
    }

    private static void loadPacketEventListeners() {
        PacketUtil.onPacketEvent(PacketType.Play.Server.PLAYER_INFO, event -> {
            if (!PacketUtil.validatePacketEvent(event)) {
                return;
            }
            Player player = event.getPlayer();
            WrapperPlayServerPlayerInfo packet = new WrapperPlayServerPlayerInfo(event.getPacket());
            Tablist tablist = TablistManager.getTablistOfPlayer(player);
            List<PlayerInfoData> oldData = packet.getData();
            ArrayList<PlayerInfoData> newData = new ArrayList<PlayerInfoData>(oldData.size());
            for (PlayerInfoData oldPlayerInfoData : oldData) {
                Player objPlayer = Bukkit.getPlayer((UUID)oldPlayerInfoData.getProfile().getUUID());
                if (objPlayer == null) {
                    newData.add(oldPlayerInfoData);
                    continue;
                }
                newData.add(tablist.onPlayerInfoPacket(oldPlayerInfoData, objPlayer));
            }
            packet.setData(newData);
        });
        PacketUtil.onPacketEvent(PacketType.Play.Server.NAMED_ENTITY_SPAWN, event -> {
            WrapperPlayServerNamedEntitySpawn packet = new WrapperPlayServerNamedEntitySpawn(event.getPacket());
            Player objPlayer = Bukkit.getPlayer((UUID)packet.getPlayerUUID());
            if (!PacketUtil.validatePacketEvent(event) || objPlayer == null) {
                return;
            }
            Player player = event.getPlayer();
            boolean tabVisible = TablistManager.getTablistOfPlayer(player).isPlayerVisible(objPlayer);
            if (!tabVisible) {
                PacketUtil.sendPacket(PacketUtil.playerInfoPacket(objPlayer, EnumWrappers.PlayerInfoAction.ADD_PLAYER), TablistManager.class, player);
                Runnable removePacketSend = () -> PacketUtil.sendPacket(PacketUtil.playerInfoPacket(objPlayer, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), TablistManager.class, player);
                Scheduling.syncDelay(Tablisknu.TABLIST_REMOTE_TAB_DELAY_SPAWN.getCurrentValue(), () -> {
                    if (playersRespawning.contains(player)) {
                        int delayTicks = 1 + Math.max(0, Tablisknu.TABLIST_REMOTE_TAB_DELAY_RESPAWN.getCurrentValue() - Tablisknu.TABLIST_REMOTE_TAB_DELAY_SPAWN.getCurrentValue());
                        Scheduling.syncDelay(delayTicks, removePacketSend);
                    } else {
                        removePacketSend.run();
                    }
                });
            }
        });
        PacketUtil.onPacketEvent(PacketType.Play.Server.RESPAWN, event -> {
            if (!PacketUtil.validatePacketEvent(event) || playersRespawning.contains(event.getPlayer())) {
                return;
            }
            Player player = event.getPlayer();
            boolean tabVisible = TablistManager.getTablistOfPlayer(player).isPlayerVisible(player);
            if (!tabVisible) {
                playersRespawning.add(player);
                PacketUtil.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.ADD_PLAYER), TablistManager.class, player);
                Scheduling.syncDelay(Tablisknu.TABLIST_REMOTE_TAB_DELAY_RESPAWN.getCurrentValue(), () -> {
                    playersRespawning.remove(player);
                    PacketUtil.sendPacket(PacketUtil.playerInfoPacket(player, EnumWrappers.PlayerInfoAction.REMOVE_PLAYER), TablistManager.class, player);
                });
            }
        });
    }
}

