/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.skin.retrieval;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import us.tlatoani.tablisknu.Tablisknu;
import us.tlatoani.tablisknu.core.base.Logging;
import us.tlatoani.tablisknu.core.base.Scheduling;
import us.tlatoani.tablisknu.core.updating.HTTPClient;
import us.tlatoani.tablisknu.skin.Skin;

public class PlayerSkinRetrieval {
    public static final String MOJANG_PROFILE_API = "https://sessionserver.mojang.com/session/minecraft/profile/%s?unsigned=false";
    private static final AtomicReference<Cache<UUID, Skin>> cacheReference = new AtomicReference();

    public static void reloadSkinCache() {
        if (Tablisknu.ENABLE_OFFLINE_SKIN_CACHE.getCurrentValue().booleanValue()) {
            int expireTimeMinutes;
            CacheBuilder builder = CacheBuilder.newBuilder();
            int maxSize = Tablisknu.OFFLINE_SKIN_CACHE_MAX_SIZE.getCurrentValue();
            if (maxSize != -1) {
                builder.maximumSize((long)maxSize);
            }
            if ((expireTimeMinutes = Tablisknu.OFFLINE_SKIN_CACHE_EXPIRE_TIME_MINUTES.getCurrentValue().intValue()) != -1) {
                builder.expireAfterAccess((long)expireTimeMinutes, TimeUnit.MINUTES);
            }
            cacheReference.set((Cache<UUID, Skin>)builder.build());
        } else {
            cacheReference.set(null);
        }
    }

    public static void onJoin(Player player) {
        if (Tablisknu.ENABLE_OFFLINE_SKIN_CACHE.getCurrentValue().booleanValue()) {
            cacheReference.get().invalidate((Object)player.getUniqueId());
        }
    }

    public static void retrieveSkinFromUUID(UUID uuid, int timeoutMillis, Consumer<Skin> callback) {
        Scheduling.async(() -> {
            Skin skin;
            Cache<UUID, Skin> cache = cacheReference.get();
            Skin skin2 = skin = cache == null ? null : (Skin)cache.getIfPresent((Object)uuid);
            if (skin == null && (skin = PlayerSkinRetrieval.skinFromMojangAPI(uuid, timeoutMillis)) != null && cache != null) {
                cache.put((Object)uuid, (Object)skin);
            }
            Skin finalSkin = skin;
            Scheduling.sync(() -> callback.accept(finalSkin));
        });
    }

    private static Skin skinFromMojangAPI(UUID uuid, int timeoutMillis) {
        try {
            HTTPClient httpClient = HTTPClient.url(MOJANG_PROFILE_API, uuid.toString().replace("-", "")).method("GET").timeout(timeoutMillis);
            int statusCode = httpClient.statusCode();
            if (statusCode != 200) {
                Logging.debug(PlayerSkinRetrieval.class, "While retrieving skin for UUID " + uuid + ", status code = " + statusCode + " != 200, aborting");
                return null;
            }
            JSONObject jsonObject = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(httpClient.getInput()));
            Logging.debug(PlayerSkinRetrieval.class, "JSON retrieved for UUID " + uuid + ": " + jsonObject);
            JSONArray properties = (JSONArray)jsonObject.get((Object)"properties");
            JSONObject property = (JSONObject)properties.get(0);
            return Skin.fromJSON(property, uuid);
        }
        catch (IOException | ClassCastException | NullPointerException | ParseException e) {
            Logging.debug(PlayerSkinRetrieval.class, "Exception while retrieving skin for UUID " + uuid);
            Logging.debug(PlayerSkinRetrieval.class, (Exception)e);
            return null;
        }
    }
}

