/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.tablisknu.skin;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import us.tlatoani.tablisknu.core.util.Utilities;
import us.tlatoani.tablisknu.player_head.HeadUtil;
import us.tlatoani.tablisknu.skin.ProfileManager;
import us.tlatoani.tablisknu.skin.Skin;

public class ExprSkinOf
extends SimpleExpression<Skin> {
    private Expression expression;

    protected Skin[] get(Event event) {
        Object value = this.expression.getSingle(event);
        if (value instanceof Player) {
            return new Skin[]{ProfileManager.getProfile((Player)value).getActualSkin()};
        }
        if (value instanceof ItemStack) {
            return new Skin[]{HeadUtil.from((ItemStack)value).map(HeadUtil::getSkin).orElse(null)};
        }
        if (value instanceof Block) {
            return new Skin[]{HeadUtil.from((Block)value).map(HeadUtil::getSkin).orElse(null)};
        }
        return new Skin[]{null};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Skin> getReturnType() {
        return Skin.class;
    }

    public String toString(Event event, boolean b) {
        return this.expression + "'s skin";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.expression = expressions[0];
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        Object value = this.expression.getSingle(event);
        Skin skinDelta = (Skin)delta[0];
        if (value == null || skinDelta == null) {
            return;
        }
        if (value instanceof ItemStack) {
            HeadUtil.from((ItemStack)value).ifPresent(head -> head.setSkin(skinDelta));
        } else if (value instanceof Block) {
            HeadUtil.from((Block)value).ifPresent(head -> head.setSkin(skinDelta));
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && Utilities.classesCompatible(ItemStack.class, this.expression.getReturnType()) || Utilities.classesCompatible(Block.class, this.expression.getReturnType())) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Skin.class});
        }
        return null;
    }
}

