/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.interfaces.skyblocks;

import com.wasteofplastic.askyblock.ASkyBlockAPI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.limeglass.sky.interfaces.challenges.IASkyBlockChallenge;
import me.limeglass.sky.interfaces.challenges.SkyblockChallenge;
import me.limeglass.sky.interfaces.islands.IASkyBlockIsland;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import me.limeglass.sky.interfaces.skyblocks.Skyblock;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class IASkyBlock
implements Skyblock {
    private ASkyBlockAPI instance;

    public IASkyBlock(ASkyBlockAPI instance) {
        this.instance = instance;
    }

    @Override
    public Set<SkyblockIsland> getTrustedOn(OfflinePlayer player) {
        return this.instance.getCoopIslands(player.getPlayer()).parallelStream().map(location -> this.getIslandAt((Location)location)).collect(Collectors.toSet());
    }

    @Override
    public Set<SkyblockChallenge> getChallenges(Player player) {
        UUID uuid = player.getUniqueId();
        Map completions = this.instance.getChallengeTimes(uuid);
        Map status = this.instance.getChallengeStatus(uuid);
        HashSet<SkyblockChallenge> challenges = new HashSet<SkyblockChallenge>();
        for (String name : status.keySet()) {
            int times = 0;
            if (completions.containsKey(name)) {
                times = (Integer)completions.get(name);
            }
            challenges.add(new IASkyBlockChallenge(name, times, uuid));
        }
        return challenges;
    }

    @Override
    public SkyblockIsland getIslandAt(Location location) {
        return new IASkyBlockIsland(this.instance.getIslandAt(location));
    }

    @Override
    public SkyblockIsland getIslandOf(OfflinePlayer player) {
        return new IASkyBlockIsland(this.instance.getIslandOwnedBy(player.getUniqueId()));
    }

    @Override
    public Location getHomeLocation(OfflinePlayer player) {
        return this.instance.getHomeLocation(player.getUniqueId());
    }

    @Override
    public Skyblock.SkyblockPlugin getPluginType() {
        return Skyblock.SkyblockPlugin.ASKYBLOCK;
    }

    public ASkyBlockAPI getInstance() {
        return this.instance;
    }
}

