/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.interfaces.islands;

import ch.njol.skript.util.BiomeUtils;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import us.talabrek.ultimateskyblock.api.IslandInfo;

public class IuSkyBlockIsland
implements SkyblockIsland {
    private IslandInfo island;

    public IuSkyBlockIsland(IslandInfo island) {
        this.island = island;
    }

    public IslandInfo getIsland() {
        return this.island;
    }

    @Override
    public boolean isWithinIsland(Location location) {
        return this.island.contains(location);
    }

    @Override
    public List<Player> getOnlineMembers() {
        return this.island.getOnlineMembers();
    }

    @Override
    public Set<OfflinePlayer> getMembers() {
        return this.island.getMembers().parallelStream().map(player -> Bukkit.getOfflinePlayer((String)player)).collect(Collectors.toSet());
    }

    @Override
    public Location getIslandLocation() {
        return this.island.getIslandLocation();
    }

    @Override
    public OfflinePlayer getLeader() {
        return Bukkit.getOfflinePlayer((String)this.island.getLeader());
    }

    @Override
    public String getLeaderName() {
        return this.island.getLeader();
    }

    @Override
    public Location getSpawnPoint() {
        Location location = this.island.getWarpLocation();
        if (location == null) {
            location = this.island.getIslandLocation();
        }
        return location;
    }

    @Override
    public String getName() {
        return this.island.getName();
    }

    @Override
    public Biome getBiome() {
        return BiomeUtils.parse((String)this.island.getBiome());
    }

    @Override
    public long getLevel() {
        return (long)this.island.getLevel();
    }
}

