/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.interfaces.islands;

import com.songoda.skyblock.api.SkyBlockAPI;
import com.songoda.skyblock.api.island.Island;
import com.songoda.skyblock.api.island.IslandEnvironment;
import com.songoda.skyblock.api.island.IslandWorld;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;

public class ISkyBlockEarthIsland
implements SkyblockIsland {
    private Island island;

    public ISkyBlockEarthIsland(Island island) {
        this.island = island;
    }

    public Island getIsland() {
        return this.island;
    }

    @Override
    public boolean isWithinIsland(Location location) {
        return SkyBlockAPI.getIslandManager().isLocationAtIsland(this.island, location);
    }

    @Override
    public List<Player> getOnlineMembers() {
        return SkyBlockAPI.getIslandManager().getMembersOnline(this.island).stream().map(uuid -> Bukkit.getPlayer((UUID)uuid)).collect(Collectors.toList());
    }

    @Override
    public Set<OfflinePlayer> getMembers() {
        throw new UnsupportedOperationException("SkyBlockEarth does not grab members as of build 54.");
    }

    @Override
    public Location getIslandLocation() {
        return this.island.getLocation(IslandWorld.OVERWORLD, IslandEnvironment.ISLAND);
    }

    @Override
    public OfflinePlayer getLeader() {
        return Bukkit.getOfflinePlayer((UUID)this.island.getOwnerUUID());
    }

    @Override
    public String getLeaderName() {
        return this.getLeader().getName();
    }

    @Override
    public Location getSpawnPoint() {
        return this.island.getLocation(IslandWorld.OVERWORLD, IslandEnvironment.MAIN);
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("SkyBlockEarth does not support names of islands.");
    }

    @Override
    public Biome getBiome() {
        return this.island.getBiome();
    }

    @Override
    public long getLevel() {
        return this.island.getLevel().getLevel();
    }
}

