/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.interfaces.islands;

import com.wasteofplastic.askyblock.ASkyBlockAPI;
import com.wasteofplastic.askyblock.Island;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.limeglass.sky.Sky;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;

public class IASkyBlockIsland
implements SkyblockIsland {
    private Island island;

    public IASkyBlockIsland(Island island) {
        this.island = island;
    }

    @Override
    public boolean isWithinIsland(Location location) {
        return this.island.inIslandSpace(location);
    }

    @Override
    public Location getIslandLocation() {
        return this.island.getCenter();
    }

    public Island getIsland() {
        return this.island;
    }

    public void setIslandLocation(Location location) {
        this.island.setCenter(location);
    }

    @Override
    public Set<OfflinePlayer> getMembers() {
        return this.island.getMembers().parallelStream().map(uuid -> Bukkit.getOfflinePlayer((UUID)uuid)).collect(Collectors.toSet());
    }

    @Override
    public List<Player> getOnlineMembers() {
        return this.island.getMembers().parallelStream().map(uuid -> Bukkit.getPlayer((UUID)uuid)).collect(Collectors.toList());
    }

    @Override
    public OfflinePlayer getLeader() {
        return Bukkit.getOfflinePlayer((UUID)this.island.getOwner());
    }

    public void setLeader(OfflinePlayer player) {
        this.island.setOwner(player.getUniqueId());
    }

    @Override
    public String getLeaderName() {
        return Bukkit.getOfflinePlayer((UUID)this.island.getOwner()).getName();
    }

    @Override
    public Location getSpawnPoint() {
        return this.island.getSpawnPoint();
    }

    @Override
    public String getName() {
        return ((ASkyBlockAPI)Sky.getSkyblock().getInstance()).getIslandName(this.getLeader().getUniqueId());
    }

    @Override
    public Biome getBiome() {
        return this.island.getBiome();
    }

    @Override
    public long getLevel() {
        return ((ASkyBlockAPI)Sky.getSkyblock().getInstance()).getLongIslandLevel(this.getLeader().getUniqueId());
    }
}

