/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.HashSet;
import me.limeglass.sky.Sky;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import me.limeglass.sky.interfaces.skyblocks.Skyblock;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Player Trusted Islands")
@Description(value={"Returns all the islands the players are trusted on."})
public class ExprPlayerTrustedIslands
extends SimpleExpression<OfflinePlayer> {
    @Nullable
    private Expression<OfflinePlayer> players;
    private Skyblock skyblock;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.players = exprs[0];
        this.skyblock = Sky.getSkyblock();
        return true;
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        HashSet<SkyblockIsland> islands = new HashSet<SkyblockIsland>();
        for (OfflinePlayer player : (OfflinePlayer[])this.players.getArray(e)) {
            islands.addAll(this.skyblock.getTrustedOn(player));
        }
        return islands.toArray(new OfflinePlayer[islands.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Trusted islands of " + this.players.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprPlayerTrustedIslands.class, OfflinePlayer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(all [[of] the]|the)] trusted islands (from|of) %offlineplayers%", "[(all [[of] the]|the)] %offlineplayers%'[s] trusted islands"});
    }
}

