/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.HashSet;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Island Online Members")
@Description(value={"Returns the online members of the islands."})
@Examples(value={"on chat:", "\tif {skyblock::player::%player%::memberchat} is true:", "\t\tmessage \"&e[&aIslandChat&e] &r%message%\" to all online memebers of player's island"})
public class ExprIslandOnlineMembers
extends SimpleExpression<Player> {
    @Nullable
    private Expression<SkyblockIsland> islands;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.islands = exprs[0];
        return true;
    }

    @Nullable
    protected Player[] get(Event e) {
        HashSet<Player> members = new HashSet<Player>();
        for (SkyblockIsland island : (SkyblockIsland[])this.islands.getArray(e)) {
            members.addAll(island.getOnlineMembers());
        }
        return members.toArray(new Player[members.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends Player> getReturnType() {
        return Player.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Island memebers of " + this.islands.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprIslandOnlineMembers.class, Player.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(all [[of] the]|the)] online [island] members (from|of) %islands%", "[(all [[of] the]|the)] %islands%'[s] online [island] members"});
    }
}

