/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.HashSet;
import me.limeglass.sky.Sky;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import me.limeglass.sky.interfaces.skyblocks.Skyblock;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Island Members")
@Description(value={"Returns the members of the islands."})
@Examples(value={"loop members of player's island:", "\tif name of loop-offlineplayer is string-argument:", "\t\tteleport string-argument parsed as player to center location of player's island"})
public class ExprIslandMembers
extends SimpleExpression<OfflinePlayer> {
    @Nullable
    private Expression<SkyblockIsland> islands;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.islands = exprs[0];
        return true;
    }

    @Nullable
    protected OfflinePlayer[] get(Event e) {
        HashSet<OfflinePlayer> members = new HashSet<OfflinePlayer>();
        for (SkyblockIsland island : (SkyblockIsland[])this.islands.getArray(e)) {
            members.addAll(island.getMembers());
        }
        return members.toArray(new OfflinePlayer[members.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends OfflinePlayer> getReturnType() {
        return OfflinePlayer.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Island members of " + this.islands.toString(e, debug);
    }

    static {
        if (Sky.getSkyblock().getPluginType() != Skyblock.SkyblockPlugin.SKYBLOCKEARTH) {
            Skript.registerExpression(ExprIslandMembers.class, OfflinePlayer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(all [[of] the]|the)] [island] members (from|of) %islands%", "[(all [[of] the]|the)] %islands%'[s] [island] members"});
        }
    }
}

