/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.sky.Sky;
import me.limeglass.sky.interfaces.islands.IASkyBlockIsland;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import me.limeglass.sky.interfaces.skyblocks.Skyblock;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Island Location")
@Description(value={"Returns the locations of the islands."})
@Examples(value={"spawn an iron golem above the center location of player's island"})
public class ExprIslandLocation
extends SimplePropertyExpression<SkyblockIsland, Location> {
    @Nullable
    public Location convert(SkyblockIsland island) {
        return island.getIslandLocation();
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    protected String getPropertyName() {
        return "island center location";
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && Sky.getSkyblock().getPluginType() == Skyblock.SkyblockPlugin.ASKYBLOCK) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Location.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null) {
            Location location = (Location)delta[0];
            for (SkyblockIsland island : (SkyblockIsland[])this.getExpr().getArray(e)) {
                if (!(island instanceof IASkyBlockIsland)) continue;
                ((IASkyBlockIsland)island).setIslandLocation(location);
            }
        }
    }

    static {
        ExprIslandLocation.register(ExprIslandLocation.class, Location.class, (String)"[island] (center [location]|location)", (String)"islands");
    }
}

