/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.sky.Sky;
import me.limeglass.sky.interfaces.islands.IASkyBlockIsland;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import me.limeglass.sky.interfaces.skyblocks.Skyblock;
import org.bukkit.block.Biome;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Island Biome")
@Description(value={"Returns the biomes of the islands."})
@Examples(value={"set biome of player's island to desert"})
public class ExprIslandBiome
extends SimplePropertyExpression<SkyblockIsland, Biome> {
    @Nullable
    public Biome convert(SkyblockIsland island) {
        return island.getBiome();
    }

    public Class<? extends Biome> getReturnType() {
        return Biome.class;
    }

    protected String getPropertyName() {
        return "island biome";
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET && Sky.getSkyblock().getPluginType() == Skyblock.SkyblockPlugin.ASKYBLOCK) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Biome.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null) {
            Biome biome = (Biome)delta[0];
            for (SkyblockIsland island : (SkyblockIsland[])this.getExpr().getArray(e)) {
                if (!(island instanceof IASkyBlockIsland)) continue;
                ((IASkyBlockIsland)island).getIsland().setBiome(biome);
            }
        }
    }

    static {
        ExprIslandBiome.register(ExprIslandBiome.class, Biome.class, (String)"[island] biome", (String)"islands");
    }
}

