/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.HashSet;
import me.limeglass.sky.Sky;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import me.limeglass.sky.interfaces.skyblocks.Skyblock;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Island At Location")
@Description(value={"Returns the islands found at locations."})
@Examples(value={"on break:", "\tif {skyblock::player::%player%::friends::*} doesn't contain owner of island at event-location:", "\t\tcancel the event"})
public class ExprIslandAt
extends SimpleExpression<SkyblockIsland> {
    private Expression<Location> locations;
    private Skyblock instance;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.locations = exprs[0];
        this.instance = Sky.getSkyblock();
        return true;
    }

    @Nullable
    protected SkyblockIsland[] get(Event e) {
        HashSet<SkyblockIsland> islands = new HashSet<SkyblockIsland>();
        for (Location location : (Location[])this.locations.getArray(e)) {
            islands.add(this.instance.getIslandAt(location));
        }
        return islands.toArray(new SkyblockIsland[islands.size()]);
    }

    public boolean isSingle() {
        return this.locations.isSingle();
    }

    public Class<? extends SkyblockIsland> getReturnType() {
        return SkyblockIsland.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Islands at " + this.locations.toString(e, debug);
    }

    static {
        Skript.registerExpression(ExprIslandAt.class, SkyblockIsland.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"island[s] at %locations%"});
    }
}

