/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.HashSet;
import me.limeglass.sky.Sky;
import me.limeglass.sky.interfaces.PlayerResolver;
import me.limeglass.sky.interfaces.challenges.SkyblockChallenge;
import me.limeglass.sky.interfaces.skyblocks.Skyblock;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Skyblock Challenges")
@Description(value={"Returns the challenges of a player."})
@Examples(value={"loop skyblock challenges of player:", "\tset {_challenges::%name of loop-challenge%} to completions of loop-challenge", "loop {_challenges::*}:", "\tmessage \"&6%loop-index% was completed %loop-value% times!\""})
public class ExprChallenges
extends SimpleExpression<SkyblockChallenge>
implements PlayerResolver {
    @Nullable
    private Expression<?> players;
    private Skyblock skyblock;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.skyblock = Sky.getSkyblock();
        this.players = exprs[0];
        return true;
    }

    @Nullable
    protected SkyblockChallenge[] get(Event e) {
        HashSet<SkyblockChallenge> challenges = new HashSet<SkyblockChallenge>();
        for (Player player : this.resolve(this.players.getArray(e))) {
            challenges.addAll(this.skyblock.getChallenges(player));
        }
        return challenges.toArray(new SkyblockChallenge[challenges.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends SkyblockChallenge> getReturnType() {
        return SkyblockChallenge.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Challenges of " + this.players.toString(e, debug);
    }

    static {
        if (Sky.getSkyblock().getPluginType() != Skyblock.SkyblockPlugin.SKYBLOCKEARTH) {
            Skript.registerExpression(ExprChallenges.class, SkyblockChallenge.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[(all [[of] the]|the)] [(island|sky[ ]block)] challenges (from|of) %players/strings%", "[(all [[of] the]|the)] %players/strings%'[s] [(island|sky[ ]block)] challenges"});
        }
    }
}

