/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import me.limeglass.sky.Sky;
import me.limeglass.sky.interfaces.challenges.SkyblockChallenge;
import me.limeglass.sky.interfaces.skyblocks.Skyblock;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Challenge Completions")
@Description(value={"Returns the amount of completions a challenge has been done."})
@Examples(value={"loop skyblock challenges of player:", "\tset {_challenges::%name of loop-challenge%} to completions of loop-challenge", "loop {_challenges::*}:", "\tmessage \"&6%loop-index% was completed %loop-value% times!\""})
public class ExprChallengeCompletions
extends SimplePropertyExpression<SkyblockChallenge, Number> {
    @Nullable
    public Number convert(SkyblockChallenge challenge) {
        return challenge.getTimesCompleted();
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    protected String getPropertyName() {
        return "challenge completions";
    }

    static {
        if (Sky.getSkyblock().getPluginType() != Skyblock.SkyblockPlugin.SKYBLOCKEARTH) {
            ExprChallengeCompletions.register(ExprChallengeCompletions.class, Number.class, (String)"[challenge] completions", (String)"challenges");
        }
    }
}

