/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Island Contains")
@Description(value={"Check if locations are within the islands bounds."})
@Examples(value={"while player is within player's island:", "\twait a second", "message \"&6You have left your own island's boundries.\""})
public class CondIslandContains
extends Condition {
    private Expression<SkyblockIsland> islands;
    private Expression<Location> locations;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.locations = exprs[0];
        this.islands = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    public boolean check(Event e) {
        return this.locations.check(e, location -> this.islands.check(e, island -> island.isWithinIsland((Location)location)), this.isNegated());
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "Locations " + this.locations.toString(e, debug) + " within islands " + this.islands.toString(e, debug);
    }

    static {
        Skript.registerCondition(CondIslandContains.class, (String[])new String[]{"%locations% (is|are) (within|on) %islands%", "%locations% (isn't|is not|aren't|are not) (within|on) %islands%"});
    }
}

