/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.askyblock.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.sky.Sky;
import me.limeglass.sky.interfaces.islands.IASkyBlockIsland;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import me.limeglass.sky.interfaces.skyblocks.Skyblock;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Island Purge Protection State")
@Description(value={"Returns the purge protection state of the islands.", "ASkyBlock exclusive"})
@Examples(value={"set purge state of player's island to false"})
public class ExprIslandPurge
extends SimplePropertyExpression<SkyblockIsland, Boolean> {
    @Nullable
    public Boolean convert(SkyblockIsland island) {
        return ((IASkyBlockIsland)island).getIsland().isPurgeProtected();
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    protected String getPropertyName() {
        return "island purge";
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null) {
            Boolean purge = (Boolean)delta[0];
            for (SkyblockIsland island : (SkyblockIsland[])this.getExpr().getArray(e)) {
                if (!(island instanceof IASkyBlockIsland)) continue;
                ((IASkyBlockIsland)island).getIsland().setPurgeProtected(purge.booleanValue());
            }
        }
    }

    static {
        if (Sky.getSkyblock().getPluginType() == Skyblock.SkyblockPlugin.ASKYBLOCK) {
            ExprIslandPurge.register(ExprIslandPurge.class, Boolean.TYPE, (String)"[island] purge [protection] state", (String)"islands");
        }
    }
}

