/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.askyblock.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.sky.Sky;
import me.limeglass.sky.interfaces.islands.IASkyBlockIsland;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import me.limeglass.sky.interfaces.skyblocks.Skyblock;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Island Locked State")
@Description(value={"Returns the islands locked states.", "ASkyBlock exclusive"})
@Examples(value={"set locked state of player's island to true"})
public class ExprIslandLocked
extends SimplePropertyExpression<SkyblockIsland, Boolean> {
    @Nullable
    public Boolean convert(SkyblockIsland island) {
        return ((IASkyBlockIsland)island).getIsland().isLocked();
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.TYPE;
    }

    protected String getPropertyName() {
        return "island locked";
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Boolean.TYPE});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null) {
            boolean locked = (Boolean)delta[0];
            for (SkyblockIsland island : (SkyblockIsland[])this.getExpr().getArray(e)) {
                if (!(island instanceof IASkyBlockIsland)) continue;
                ((IASkyBlockIsland)island).getIsland().setLocked(locked);
            }
        }
    }

    static {
        if (Sky.getSkyblock().getPluginType() == Skyblock.SkyblockPlugin.ASKYBLOCK) {
            ExprIslandLocked.register(ExprIslandLocked.class, Boolean.TYPE, (String)"[island] locked [state]", (String)"islands");
        }
    }
}

