/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.sky.elements.askyblock.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Date;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.sky.Sky;
import me.limeglass.sky.interfaces.islands.IASkyBlockIsland;
import me.limeglass.sky.interfaces.islands.SkyblockIsland;
import me.limeglass.sky.interfaces.skyblocks.Skyblock;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Island Creation Date")
@Description(value={"Returns the creation date of the islands.", "ASkyBlock exclusive"})
@Examples(value={"set {_difference} to the difference between now and creation date of {_island}"})
public class ExprIslandCreationDate
extends SimplePropertyExpression<SkyblockIsland, Date> {
    @Nullable
    public Date convert(SkyblockIsland island) {
        return new Date(((IASkyBlockIsland)island).getIsland().getCreatedDate());
    }

    public Class<? extends Date> getReturnType() {
        return Date.class;
    }

    protected String getPropertyName() {
        return "island creation date";
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Date.class});
        }
        return null;
    }

    public void change(Event e, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta != null) {
            Date date = (Date)delta[0];
            for (SkyblockIsland island : (SkyblockIsland[])this.getExpr().getArray(e)) {
                if (!(island instanceof IASkyBlockIsland)) continue;
                ((IASkyBlockIsland)island).getIsland().setCreatedDate(date.getTimestamp());
            }
        }
    }

    static {
        if (Sky.getSkyblock().getPluginType() == Skyblock.SkyblockPlugin.ASKYBLOCK) {
            ExprIslandCreationDate.register(ExprIslandCreationDate.class, Date.class, (String)"[island] creation date", (String)"islands");
        }
    }
}

