/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.utils;

import ch.njol.skript.Skript;
import ch.njol.skript.util.Timespan;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import me.limeglass.skungee.objects.SkungeePlayer;
import me.limeglass.skungee.spigot.Skungee;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class Utils {
    public static boolean compareArrays(String[] arg1, String[] arg2) {
        if (arg1.length != arg2.length) {
            return false;
        }
        Arrays.sort(arg1);
        Arrays.sort(arg2);
        return Arrays.equals(arg1, arg2);
    }

    public static boolean compareArrays(byte[] arg1, byte[] arg2) {
        if (arg1.length != arg2.length) {
            return false;
        }
        Arrays.sort(arg1);
        Arrays.sort(arg2);
        return Arrays.equals(arg1, arg2);
    }

    public static Boolean isEnum(Class<?> clazz, String object) {
        try {
            Method method = clazz.getMethod("valueOf", String.class);
            method.setAccessible(true);
            method.invoke(clazz, object.replace("\"", "").trim().replace(" ", "_").toUpperCase());
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException error) {
            return false;
        }
    }

    public static <T> T getEnum(Class<T> clazz, String object) {
        try {
            Method method = clazz.getMethod("valueOf", String.class);
            method.setAccessible(true);
            return (T)method.invoke(clazz, object.replace("\"", "").trim().replace(" ", "_").toUpperCase());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException error) {
            Skungee.consoleMessage("&cUnknown type " + object + " in " + clazz.getName());
            return null;
        }
    }

    public static SkungeePlayer[] toSkungeePlayers(Object ... players) {
        HashSet<SkungeePlayer> skungeePlayers = new HashSet<SkungeePlayer>();
        for (Object player : players) {
            if (player instanceof Player) {
                skungeePlayers.add(new SkungeePlayer(true, ((Player)player).getUniqueId(), ((Player)player).getName()));
                continue;
            }
            if (!(player instanceof String)) continue;
            UUID uuid = null;
            try {
                uuid = UUID.fromString((String)player);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (uuid != null) {
                Player p = Bukkit.getPlayer((UUID)uuid);
                if (p != null) {
                    skungeePlayers.add(new SkungeePlayer(false, uuid, Bukkit.getPlayer((UUID)uuid).getName()));
                    continue;
                }
                skungeePlayers.add(new SkungeePlayer(false, null, (String)player));
                continue;
            }
            skungeePlayers.add(new SkungeePlayer(false, null, (String)player));
        }
        return skungeePlayers.toArray(new SkungeePlayer[skungeePlayers.size()]);
    }

    public static Class<?> getArrayClass(Class<?> parameter) {
        return Array.newInstance(parameter, 0).getClass();
    }

    public static String cc(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static int getTicks(Timespan time) {
        if (Skript.methodExists(Timespan.class, (String)"getTicks_i", (Class[])new Class[0])) {
            Long tick = time.getTicks_i();
            return ((Number)tick).intValue();
        }
        return time.getTicks();
    }

    public static void copyDirectory(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            if (!destination.exists()) {
                destination.mkdir();
            }
            String[] files = source.list();
            for (int i = 0; i < files.length; ++i) {
                Utils.copyDirectory(new File(source, files[i]), new File(destination, files[i]));
            }
        } else if (source.exists()) {
            int len;
            FileInputStream in = new FileInputStream(source);
            FileOutputStream out = new FileOutputStream(destination);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findPort(int start, int max) {
        int port;
        IOException lastException = null;
        for (port = start; port < max; ++port) {
            ServerSocket socket = null;
            try {
                socket = new ServerSocket(port);
                socket.setReuseAddress(true);
                int n = port;
                return n;
            }
            catch (IOException e) {
                lastException = e;
                continue;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (lastException != null) {
            Skungee.exception(lastException, "Couldn't find a port between " + start + " and " + port);
        }
        return -1;
    }
}

