/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.utils;

import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.localization.Language;
import ch.njol.skript.util.EnumUtils;
import java.util.ArrayList;
import java.util.Arrays;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.lang.SkungeeParser;
import org.eclipse.jdt.annotation.Nullable;

public class LangEnumParser<T extends Enum<T>>
extends SkungeeParser<T> {
    private EnumUtils<T> enumUtil;
    private final Class<T> clazz;
    private final String codeName;

    public LangEnumParser(String variableNamePattern, Class<T> clazz) {
        super(variableNamePattern);
        this.clazz = clazz;
        this.codeName = variableNamePattern;
        try {
            this.enumUtil = new EnumUtils(clazz, variableNamePattern + "s");
            ArrayList<String> enumNames = new ArrayList<String>();
            for (Enum e : (Enum[])clazz.getEnumConstants()) {
                enumNames.addAll(Arrays.asList(Language.get_((String)(variableNamePattern + "s." + e.name()))));
            }
            Skungee.getInstance().getConfiguration("syntax").set("Syntax.Enums." + clazz.getSimpleName() + ".names", enumNames);
        }
        catch (NullPointerException error) {
            Skungee.consoleMessage("&cThe class: " + clazz.getName() + " for classinfo name: " + variableNamePattern + " isn't an Enum!");
        }
        Skungee.save("syntax");
    }

    @Nullable
    public T parse(String string, ParseContext parseContent) {
        Enum result;
        if (string.startsWith(this.codeName + ":")) {
            string = string.substring(this.codeName.length() + 1, string.length());
        }
        string = string.replaceAll("_", " ");
        Enum enum_ = result = this.enumUtil != null ? this.enumUtil.parse(string) : null;
        if (result != null) {
            return (T)result;
        }
        string = string.replaceAll(" ", "_");
        try {
            return Enum.valueOf(this.clazz, string.toUpperCase());
        }
        catch (IllegalArgumentException error) {
            return null;
        }
    }

    @Override
    public String toString(T t, int i) {
        return ((Enum)t).name().toLowerCase().replaceAll("_", " ");
    }

    @Override
    public String toVariableNameString(T t) {
        return this.codeName + ':' + ((Enum)t).toString();
    }

    @Override
    public String getVariableNamePattern() {
        return this.codeName + ":.+";
    }
}

