/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.sockets;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import me.limeglass.skungee.EncryptionUtil;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.objects.packets.BungeePacket;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.sockets.Sockets;
import me.limeglass.skungee.spigot.sockets.SpigotPacketHandler;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.eclipse.jdt.annotation.Nullable;

public class SpigotRunnable
implements Runnable {
    private InetAddress address;
    private Socket socket;

    public SpigotRunnable(Socket socket) {
        this.socket = socket;
        this.address = socket.getInetAddress();
    }

    @Override
    public void run() {
        block22: {
            FileConfiguration configuration = Skungee.getInstance().getConfig();
            if (configuration.getBoolean("security.breaches.enabled", false)) {
                List addresses = configuration.getStringList("security.breaches.blacklisted");
                if (Sockets.blocked.contains(this.address) || addresses.contains(this.address.getHostName())) {
                    return;
                }
            }
            try {
                String algorithm = configuration.getString("security.encryption.cipherAlgorithm", "AES/CBC/PKCS5Padding");
                String keyString = configuration.getString("security.encryption.cipherKey", "insert 16 length");
                ObjectInputStream objectInputStream = new ObjectInputStream(this.socket.getInputStream());
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.socket.getOutputStream());
                EncryptionUtil encryption = Skungee.getInstance().getEncrypter();
                Object object = objectInputStream.readObject();
                if (object != null) {
                    Object packetData;
                    BungeePacket packet = null;
                    try {
                        packet = configuration.getBoolean("security.encryption.enabled", false) ? (BungeePacket)encryption.decrypt(keyString, algorithm, (byte[])object) : (BungeePacket)object;
                    }
                    catch (ClassCastException e) {
                        Skungee.consoleMessage("", "Some security settings didn't match for the incoming packet.", "Make sure all your security options on the Spigot servers match the same as in the Bungeecord Skungee configuration.yml", "The packet could not be read, thus being cancelled.");
                        if (configuration.getBoolean("security.debug")) {
                            Skungee.exception(e, "Could not decrypt packet " + UniversalSkungee.getPacketDebug(packet));
                        }
                        this.attempt(this.address, null);
                        return;
                    }
                    if (packet.getPassword() != null) {
                        Object password;
                        if (configuration.getBoolean("security.password.hash", true)) {
                            password = encryption.hash();
                            if (configuration.getBoolean("security.password.hashFile", false) && encryption.isFileHashed().booleanValue()) {
                                password = encryption.getHashFromFile();
                            }
                            if (!Arrays.equals(password, packet.getPassword())) {
                                this.incorrectPassword(packet);
                                return;
                            }
                        } else {
                            password = (String)encryption.deserialize(packet.getPassword());
                            if (!password.equals(configuration.getString("security.password.password"))) {
                                this.incorrectPassword(packet);
                                return;
                            }
                        }
                    } else if (configuration.getBoolean("security.password.enabled", false)) {
                        this.incorrectPassword(packet);
                        return;
                    }
                    if (Sockets.attempts.containsKey(this.address)) {
                        Sockets.attempts.remove(this.address);
                    }
                    if ((packetData = SpigotPacketHandler.handlePacket(packet, this.address)) != null) {
                        if (configuration.getBoolean("security.encryption.enabled", false)) {
                            byte[] serialized = encryption.serialize(packetData);
                            byte[] encrypted = encryption.encrypt(keyString, algorithm, serialized);
                            objectOutputStream.writeObject(encrypted);
                        } else {
                            objectOutputStream.writeObject(packetData);
                        }
                    }
                }
                objectInputStream.close();
                objectOutputStream.close();
            }
            catch (IOException | ClassNotFoundException e) {
                if (!configuration.getBoolean("security.debug")) break block22;
                Skungee.exception(e, "Could not read incoming packet");
            }
        }
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void incorrectPassword(BungeePacket packet) {
        this.attempt(this.address, packet);
        Skungee.consoleMessage("&cA BungeePacket with an incorrect password has just been recieved and blocked!");
        Skungee.consoleMessage("&cThe packet came from: " + this.socket.getInetAddress());
        Skungee.consoleMessage("&cThe packet type was: " + (Object)((Object)packet.getType()));
    }

    private void attempt(InetAddress address, @Nullable BungeePacket packet) {
        FileConfiguration configuration = Skungee.getInstance().getConfig();
        if (configuration.getBoolean("security.breaches.enabled", false)) {
            int attempts = 0;
            if (Sockets.attempts.containsKey(address)) {
                attempts = Sockets.attempts.get(address);
                Sockets.attempts.remove(address, attempts);
            }
            Sockets.attempts.put(address, ++attempts);
            if (attempts >= configuration.getInt("security.breaches.attempts", 30)) {
                if (configuration.getBoolean("security.breaches.log", false)) {
                    this.log("", "&cA BungeePacket with an incorrect password has just been recieved and blocked!", "&cThe packet came from: " + this.socket.getInetAddress());
                    if (packet != null) {
                        this.log("&cThe packet type was: " + (Object)((Object)packet.getType()));
                    }
                }
                if (configuration.getBoolean("security.breaches.shutdown", false)) {
                    Bukkit.shutdown();
                }
                if (configuration.getBoolean("security.breaches.blockAddress", false) && !Sockets.blocked.contains(address)) {
                    Sockets.blocked.add(address);
                }
            }
        }
    }

    private void log(String ... strings) {
        try {
            Logger logger = Logger.getLogger("log");
            FileHandler handler = new FileHandler(Skungee.getInstance().getDataFolder() + File.separator + "breaches.log");
            handler.setFormatter(new SimpleFormatter());
            logger.addHandler(handler);
            for (String string : strings) {
                logger.info(string);
            }
        }
        catch (IOException | SecurityException e) {
            Skungee.exception(e, "Error logging a breach.");
        }
    }
}

