/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.sockets;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.Config;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.Version;
import ch.njol.skript.variables.Variables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.objects.SkungeeVariable;
import me.limeglass.skungee.objects.events.SkungeeMessageEvent;
import me.limeglass.skungee.objects.events.SkungeePingEvent;
import me.limeglass.skungee.objects.events.SkungeePlayerChatEvent;
import me.limeglass.skungee.objects.events.SkungeePlayerCommandEvent;
import me.limeglass.skungee.objects.events.SkungeePlayerDisconnect;
import me.limeglass.skungee.objects.events.SkungeePlayerSwitchServer;
import me.limeglass.skungee.objects.packets.BungeePacket;
import me.limeglass.skungee.objects.packets.BungeePacketType;
import me.limeglass.skungee.objects.packets.ServerPingPacket;
import me.limeglass.skungee.spigot.Skungee;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class SpigotPacketHandler {
    public static Object handlePacket(BungeePacket packet, InetAddress address) {
        if (!Skungee.getInstance().getConfig().getBoolean("IgnoreSpamPackets", true)) {
            Skungee.debugMessage("Recieved " + UniversalSkungee.getPacketDebug(packet));
        } else if (packet.getType() != BungeePacketType.GLOBALSCRIPTS) {
            Skungee.debugMessage("Recieved " + UniversalSkungee.getPacketDebug(packet));
        }
        switch (packet.getType()) {
            case PINGSERVER: {
                break;
            }
            case PLAYERCOMMAND: {
                if (packet.getObject() == null || packet.getSetObject() == null || packet.getPlayers() == null) break;
                String server = (String)packet.getSetObject();
                String command = (String)packet.getObject();
                SkungeePlayerCommandEvent event = new SkungeePlayerCommandEvent(command, server, packet.getPlayers());
                Bukkit.getPluginManager().callEvent((Event)event);
                return event.isCancelled();
            }
            case PLAYERCHAT: {
                if (packet.getObject() == null || packet.getSetObject() == null || packet.getPlayers() == null) break;
                String server = (String)packet.getSetObject();
                String message = (String)packet.getObject();
                SkungeePlayerChatEvent event = new SkungeePlayerChatEvent(message, server, packet.getPlayers());
                Bukkit.getPluginManager().callEvent((Event)event);
                return event.isCancelled();
            }
            case PLAYERDISCONNECT: {
                if (packet.getObject() == null || packet.getPlayers() == null) break;
                Bukkit.getPluginManager().callEvent((Event)new SkungeePlayerDisconnect((String)packet.getObject(), packet.getPlayers()));
                break;
            }
            case PLAYERSWITCH: {
                if (packet.getObject() == null || packet.getPlayers() == null) break;
                Bukkit.getPluginManager().callEvent((Event)new SkungeePlayerSwitchServer((String)packet.getObject(), packet.getPlayers()));
                break;
            }
            case PLAYERLOGIN: {
                break;
            }
            case EVALUATE: {
                if (packet.getObject() == null) break;
                for (String effect : (String[])packet.getObject()) {
                    if (Effect.parse((String)effect, null) == null) {
                        Skungee.infoMessage("There was an error executing effect: " + effect);
                        Skungee.infoMessage("Possibly not an effect for this server? Make sure you have any addons that could run this effect and that it looks realistic.");
                        continue;
                    }
                    Effect.parse((String)effect, null).run(null);
                }
                break;
            }
            case GLOBALSCRIPTS: {
                File scriptsFolder = new File(Skript.getInstance().getDataFolder().getAbsolutePath() + File.separator + "scripts");
                Set<File> scripts = SpigotPacketHandler.getFiles(scriptsFolder, new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.toLowerCase().endsWith(".sk") && !name.startsWith("-");
                    }
                });
                Map data = (Map)packet.getObject();
                if (Skungee.getInstance().getConfig().getBoolean("GlobalScripts.MimicExact", false)) {
                    boolean reload = false;
                    for (File script : scripts) {
                        if (data.keySet().parallelStream().anyMatch(name -> name.equals(script.getName()))) continue;
                        reload = true;
                        try {
                            Files.deleteIfExists(script.toPath());
                            if (script.getParentFile().listFiles().length != 0) continue;
                            Files.deleteIfExists(script.getParentFile().toPath());
                        }
                        catch (IOException iOException) {}
                    }
                    if (reload) {
                        Bukkit.getScheduler().runTask((Plugin)Skungee.getInstance(), () -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"sk reload scripts"));
                    }
                }
                for (final Map.Entry entry : data.entrySet()) {
                    try {
                        File script;
                        if (scripts.parallelStream().anyMatch(file -> file.getName().equals(entry.getKey()))) {
                            Boolean reload = false;
                            File script2 = File.createTempFile("Skungee", (String)entry.getKey());
                            PrintStream out = new PrintStream(new FileOutputStream(script2));
                            out.print(StringUtils.join((Collection)((Collection)entry.getValue()), (char)'\n'));
                            out.close();
                            for (File similar : scripts.parallelStream().filter(file -> file.getName().equals(entry.getKey())).collect(Collectors.toSet())) {
                                if (Arrays.equals(Files.readAllBytes(script2.toPath()), Files.readAllBytes(similar.toPath()))) continue;
                                Files.deleteIfExists(similar.toPath());
                                reload = true;
                            }
                            if (reload.booleanValue()) {
                                File newScript = new File(scriptsFolder + File.separator + (String)entry.getKey());
                                com.google.common.io.Files.move((File)script2, (File)newScript);
                                Bukkit.getScheduler().runTask((Plugin)Skungee.getInstance(), new Runnable(){

                                    @Override
                                    public void run() {
                                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("sk reload " + (String)entry.getKey()));
                                        if (Skungee.getInstance().getConfig().getBoolean("GlobalScripts.Messages", true)) {
                                            Skungee.consoleMessage("&6GlobalScripts: reloaded script " + (String)entry.getKey() + " for this server!");
                                        }
                                    }
                                });
                            }
                            script2.delete();
                            continue;
                        }
                        script = new File(scriptsFolder + File.separator + (String)entry.getKey());
                        PrintStream out = new PrintStream(new FileOutputStream(script));
                        out.print(StringUtils.join((Collection)((Collection)entry.getValue()), (char)'\n'));
                        out.close();
                        String name2 = scriptsFolder + File.separator + script.getName();
                        Config config = new Config((InputStream)new FileInputStream(script), name2, true, false, ":");
                        if (Skript.getVersion().isLargerThan(new Version("2.2-dev31c"))) {
                            config = new Config((InputStream)new FileInputStream(script), name2, script, true, false, ":");
                        }
                        ScriptLoader.loadScripts((Config[])new Config[]{config});
                        if (!Skungee.getInstance().getConfig().getBoolean("GlobalScripts.Messages", true)) continue;
                        Skungee.consoleMessage("&6GlobalScripts: created script " + (String)entry.getKey() + " for this server!");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            case UPDATEVARIABLES: {
                Object objectName = packet.getObject();
                Object objectValues = packet.getSetObject();
                if (objectName == null || objectValues == null) {
                    return null;
                }
                String name3 = (String)objectName;
                SkungeeVariable.Value[] values = (SkungeeVariable.Value[])objectValues;
                Object[] objects = new Object[values.length];
                for (int i = 0; i < values.length; ++i) {
                    objects[i] = Classes.deserialize((String)values[i].type, (byte[])values[i].data);
                }
                Variables.setVariable((String)name3, (Object)objects, null, (boolean)false);
                break;
            }
            case SHUTDOWN: {
                Bukkit.shutdown();
                break;
            }
            case SERVERLISTPING: {
                if (!(packet instanceof ServerPingPacket)) break;
                SkungeePingEvent event = new SkungeePingEvent((ServerPingPacket)packet);
                Bukkit.getPluginManager().callEvent((Event)event);
                return event.getPacket();
            }
            case SKUNGEEMESSAGES: {
                if (packet.getObject() == null || packet.getSetObject() == null) break;
                for (String channel : (String[])packet.getSetObject()) {
                    Bukkit.getScheduler().runTask((Plugin)Skungee.getInstance(), () -> Bukkit.getPluginManager().callEvent((Event)new SkungeeMessageEvent(channel, (String[])packet.getObject())));
                }
                break;
            }
        }
        return null;
    }

    private static Set<File> getFiles(File root, FilenameFilter filter, Set<File> toAdd) {
        for (File file : root.listFiles()) {
            if (file.isDirectory()) {
                toAdd.addAll(SpigotPacketHandler.getFiles(file, filter, toAdd));
                continue;
            }
            if (!filter.accept(file, file.getName())) continue;
            toAdd.add(file);
        }
        return toAdd;
    }

    private static Set<File> getFiles(File root, FilenameFilter filter) {
        HashSet<File> files = new HashSet<File>();
        for (File file : root.listFiles()) {
            if (file.isDirectory()) {
                files.addAll(SpigotPacketHandler.getFiles(file, filter, files));
                continue;
            }
            if (!filter.accept(file, file.getName())) continue;
            files.add(file);
        }
        return files;
    }
}

