/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.elements.expressions.events;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.ExpressionType;
import java.util.List;
import java.util.regex.Pattern;
import me.limeglass.skungee.objects.events.SkungeePingEvent;
import me.limeglass.skungee.objects.packets.ServerPingPacket;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.lang.SkungeeExpression;
import me.limeglass.skungee.spigot.utils.annotations.Changers;
import me.limeglass.skungee.spigot.utils.annotations.Events;
import me.limeglass.skungee.spigot.utils.annotations.ExpressionProperty;
import me.limeglass.skungee.spigot.utils.annotations.Patterns;
import me.limeglass.skungee.spigot.utils.annotations.Settable;
import org.bukkit.event.Event;

@Name(value="Bungeecord Ping event protocol")
@Description(value={"Returns the protocol invloved in the Bungeecord ping event. A number may only be called on the protocol section of the syntax.", "You may find protocol IDs here http://wiki.vg/index.php?title=Protocol_History&printable=yes"})
@Patterns(value={"(ping|server list|event) bungee[[ ]cord] (version|protocol) [(1\u00a6name|2\u00a6(protocol|number))]", "bungee[[ ]cord] (ping|server list|event) (version|protocol) [(1\u00a6name|2\u00a6(protocol|number))]"})
@ExpressionProperty(value=ExpressionType.SIMPLE)
@Changers(value={Changer.ChangeMode.SET})
@Settable(value={String.class, Number.class})
@Events(value={SkungeePingEvent.class})
public class ExprPingProtocol
extends SkungeeExpression<String> {
    protected String[] get(Event event) {
        if (((SkungeePingEvent)event).getPacket().getVersion() == null) {
            return null;
        }
        ServerPingPacket packet = ((SkungeePingEvent)event).getPacket();
        if (this.patternMark > 0) {
            String[] protocol = packet.getVersion().split(Pattern.quote(":"));
            if (protocol.length < 2) {
                Skript.error((String)"The protocol was not formated incorrectly in the Bungeecord Ping event protocol (name:protocol)");
                return null;
            }
            return new String[]{this.patternMark == 1 ? protocol[0] : protocol[1]};
        }
        return new String[]{((SkungeePingEvent)event).getPacket().getVersion()};
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || ((SkungeePingEvent)event).getPacket().getObject() == null) {
            return;
        }
        ServerPingPacket packet = ((SkungeePingEvent)event).getPacket();
        List protocols = (List)((SkungeePingEvent)event).getPacket().getObject();
        if (this.patternMark > 0) {
            String[] protocol = packet.getVersion().split(Pattern.quote(":"));
            if (protocol.length < 2) {
                Skript.error((String)"The protocol was formated incorrectly in the Bungeecord Ping event protocol (name:protocol)");
                return;
            }
            if (this.patternMark == 1) {
                if (delta[0] instanceof String) {
                    packet.setVersion((String)delta[0] + ":" + protocol[1]);
                }
            } else if (delta[0] instanceof Number) {
                int version = ((Number)delta[0]).intValue();
                if (version < 1) {
                    Skript.error((String)("The protocol version " + version + " is an invalid entry."));
                    return;
                }
                if (!protocols.contains(version) && !Skungee.getInstance().getConfig().getBoolean("PingEventProtocolOverride", false)) {
                    Skript.error((String)("The protocol version " + version + " is not an accepted protocol version. You can disable this restriction in the configurations. The following are valid protocols: " + protocols));
                    return;
                }
                packet.setVersion(protocol[0] + ":" + version);
            }
        } else {
            this.patternMark = 1;
            this.change(event, new Object[]{((String)delta[0]).split(Pattern.quote(":"))[0]}, mode);
            this.patternMark = 2;
            this.change(event, new Object[]{((String)delta[0]).split(Pattern.quote(":"))[1]}, mode);
        }
    }
}

