/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.UnparsedLiteral;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.StringMode;
import ch.njol.skript.variables.SerializedVariable;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.ArrayList;
import me.limeglass.skungee.objects.SkungeeEnums;
import me.limeglass.skungee.objects.SkungeeVariable;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.objects.packets.SkungeePacketType;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.lang.SkungeeExpression;
import me.limeglass.skungee.spigot.sockets.Sockets;
import me.limeglass.skungee.spigot.utils.Utils;
import me.limeglass.skungee.spigot.utils.annotations.Patterns;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Network variable")
@Description(value={"Returns a variable that is stored on the Bungeecord Skungee."})
@Patterns(value={"[skungee] (global|network|bungee[[ ]cord]) variable [(from|of)] %objects%"})
public class ExprNetworkVariable
extends SkungeeExpression<Object> {
    private static Variable<?> variable;
    private VariableString variableString;

    @Override
    public boolean isSingle() {
        return !variable.isList();
    }

    private <T> Expression<T> getExpression(Expression<?> expr) {
        if (expr instanceof UnparsedLiteral) {
            Literal parsedLiteral = ((UnparsedLiteral)expr).getConvertedExpression(new Class[]{Object.class});
            return parsedLiteral == null ? expr : parsedLiteral;
        }
        return expr;
    }

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (expressions[0] instanceof Variable) {
            variable = (Variable)expressions[0];
        } else {
            Expression expression = this.getExpression(expressions[0]);
            if (expression instanceof Variable) {
                variable = (Variable)expression;
            }
        }
        if (variable != null) {
            if (variable.isLocal()) {
                Skript.error((String)"Network Variables can not be a local variable.");
                return false;
            }
            String var = variable.toString().substring(1, variable.toString().length() - 1);
            this.variableString = VariableString.newInstance((String)var, (StringMode)StringMode.VARIABLE_NAME);
            return true;
        }
        Skript.error((String)"Network Variables must be in a variable format!");
        return false;
    }

    @Nullable
    protected Object[] get(Event event) {
        Object variable = Sockets.send(new SkungeePacket((Boolean)true, SkungeePacketType.NETWORKVARIABLE, (Object)this.variableString.toString(event)));
        if (variable == null) {
            return null;
        }
        if (!(variable instanceof SkungeeVariable.Value[])) {
            Skungee.consoleMessage("A network variable under the index of \"" + this.variableString.toString(event) + "\" returned a value that could not be handled.");
            Skungee.consoleMessage("This could be due to an old format, in that case please reset this value or reset it.");
            Skungee.consoleMessage("Report this type to the developers of Skungee: &f" + variable.getClass().getName());
            return null;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (SkungeeVariable.Value value : (SkungeeVariable.Value[])variable) {
            objects.add(Classes.deserialize((String)value.type, (byte[])value.data));
        }
        if (objects.isEmpty()) {
            return null;
        }
        return objects.toArray(new Object[objects.size()]);
    }

    @Override
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.isSingle() && (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.REMOVE_ALL)) {
            Skript.error((String)("Skungee cannot " + mode.toString() + " values from a single variable. Skungee would have to send two communication packets, thus resulting in performance loss. Please get, modify and set to " + mode.toString() + " single values if you insist on doing it this way."));
            return null;
        }
        return (Class[])CollectionUtils.array((Object[])new Class[]{this.isSingle() ? Object.class : Object[].class});
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        SkungeeEnums.SkriptChangeMode changer = Utils.getEnum(SkungeeEnums.SkriptChangeMode.class, mode.toString());
        if (changer == null) {
            return;
        }
        SkungeeVariable.Value[] values = null;
        if (delta != null) {
            values = new SkungeeVariable.Value[delta.length];
            for (int i = 0; i < delta.length; ++i) {
                SerializedVariable.Value value = Classes.serialize((Object)delta[i]);
                values[i] = new SkungeeVariable.Value(value.type, value.data);
            }
        }
        SkungeeVariable variable = new SkungeeVariable(this.variableString.toString(event), values);
        Sockets.send(new SkungeePacket((Boolean)true, SkungeePacketType.NETWORKVARIABLE, (Object)variable, changer));
    }
}

