/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.elements;

import ch.njol.skript.Skript;
import ch.njol.skript.expressions.base.PropertyExpression;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import java.util.Arrays;
import me.limeglass.skungee.spigot.Metrics;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.Syntax;
import me.limeglass.skungee.spigot.utils.EnumClassInfo;
import me.limeglass.skungee.spigot.utils.ReflectionUtil;
import me.limeglass.skungee.spigot.utils.TypeClassInfo;
import me.limeglass.skungee.spigot.utils.annotations.Disabled;
import me.limeglass.skungee.spigot.utils.annotations.ExpressionProperty;
import me.limeglass.skungee.spigot.utils.annotations.Patterns;
import me.limeglass.skungee.spigot.utils.annotations.Properties;
import me.limeglass.skungee.spigot.utils.annotations.PropertiesAddition;
import me.limeglass.skungee.spigot.utils.annotations.RegisterEnum;
import me.limeglass.skungee.spigot.utils.annotations.RegisterType;
import me.limeglass.skungee.spigot.utils.annotations.User;

public class Register {
    public static void metrics(Metrics metrics) {
        metrics.addCustomChart(new Metrics.SimplePie("skript_version"){

            @Override
            public String getValue() {
                return Skript.getVersion().toString();
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("use_encryption"){

            @Override
            public String getValue() {
                return Skungee.getInstance().getConfig().getBoolean("security.encryption.enabled", false) + "";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("use_breaches"){

            @Override
            public String getValue() {
                return Skungee.getInstance().getConfig().getBoolean("security.breaches.enabled", false) + "";
            }
        });
        metrics.addCustomChart(new Metrics.SimplePie("use_password"){

            @Override
            public String getValue() {
                return Skungee.getInstance().getConfig().getBoolean("security.password.enabled", false) + "";
            }
        });
        Skungee.debugMessage("Metrics registered!");
    }

    static {
        for (Class<?> clazz : ReflectionUtil.getClasses(Skungee.getInstance(), Skungee.getInstance().getPackageName())) {
            if (clazz.getName().contains("serverinstances") && !Skungee.getInstance().getConfiguration("config").getBoolean("ServerInstances", false) || clazz.isAnnotationPresent(Disabled.class)) continue;
            Object[] syntax = null;
            ExpressionType type = ExpressionType.COMBINED;
            if (clazz.isAnnotationPresent(Patterns.class)) {
                syntax = Syntax.register(clazz, clazz.getAnnotation(Patterns.class).value());
            } else {
                String[] values;
                if (!PropertyExpression.class.isAssignableFrom(clazz) || !clazz.isAnnotationPresent(Properties.class)) continue;
                type = ExpressionType.PROPERTY;
                String[] properties = clazz.getAnnotation(Properties.class).value();
                String additions = clazz.isAnnotationPresent(PropertiesAddition.class) ? " " + clazz.getAnnotation(PropertiesAddition.class).value() + " " : " ";
                String input1 = "[the] ";
                String input2 = "";
                if (properties.length > 2 && properties[2] != null) {
                    int var = Integer.parseInt(properties[2].substring(1, 2));
                    if (var == 1) {
                        input1 = properties[2].substring(3, properties[2].length());
                    } else {
                        input2 = properties[2].substring(3, properties[2].length());
                    }
                }
                if ((syntax = Syntax.register(clazz, values = new String[]{Skungee.getNameplate() + input1 + " " + properties[1] + " (of|from)" + additions + "%" + properties[0] + "%", Skungee.getNameplate() + input2 + "%" + properties[0] + "%['s]" + additions.replace("[the] ", "") + properties[1]})) == null) {
                    Skungee.debugMessage("&cThere was an issue registering the syntax for " + clazz.getName() + ". Make sure that the SyntaxToggles.yml is set for this syntax.");
                }
            }
            if (clazz.isAnnotationPresent(RegisterEnum.class)) {
                try {
                    String user = null;
                    String enumType = clazz.getAnnotation(RegisterEnum.class).value();
                    Class returnType = clazz.getAnnotation(RegisterEnum.class).ExprClass();
                    if (returnType.equals(String.class)) {
                        returnType = ((Expression)clazz.newInstance()).getReturnType();
                    }
                    if (clazz.isAnnotationPresent(User.class)) {
                        user = clazz.getAnnotation(User.class).value();
                    }
                    EnumClassInfo.create(returnType, enumType, user).register();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
            if (clazz.isAnnotationPresent(RegisterType.class)) {
                try {
                    String typeName = clazz.getAnnotation(RegisterType.class).value();
                    Class returnType = clazz.getAnnotation(RegisterType.class).ExprClass();
                    if (returnType.equals(String.class)) {
                        returnType = ((Expression)clazz.newInstance()).getReturnType();
                    }
                    TypeClassInfo.create(returnType, typeName).register();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
            if (syntax == null) continue;
            if (Effect.class.isAssignableFrom(clazz)) {
                Skript.registerEffect(clazz, (String[])syntax);
                Skungee.debugMessage("&5Registered Effect " + clazz.getSimpleName() + " (" + clazz.getCanonicalName() + ") with syntax " + Arrays.toString(syntax));
                continue;
            }
            if (Condition.class.isAssignableFrom(clazz)) {
                Skript.registerCondition(clazz, (String[])syntax);
                Skungee.debugMessage("&5Registered Condition " + clazz.getSimpleName() + " (" + clazz.getCanonicalName() + ") with syntax " + Arrays.toString(syntax));
                continue;
            }
            if (!Expression.class.isAssignableFrom(clazz)) continue;
            if (clazz.isAnnotationPresent(ExpressionProperty.class)) {
                type = clazz.getAnnotation(ExpressionProperty.class).value();
            }
            try {
                Skript.registerExpression(clazz, (Class)((Expression)clazz.newInstance()).getReturnType(), (ExpressionType)type, (String[])syntax);
                Skungee.debugMessage("&5Registered Expression " + type.toString() + " " + clazz.getSimpleName() + " (" + clazz.getCanonicalName() + ") with syntax " + Arrays.toString(syntax));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                Skungee.consoleMessage("&cFailed to register expression " + clazz.getCanonicalName());
                e.printStackTrace();
            }
        }
    }
}

