/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.variables;

import com.google.common.collect.Lists;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.sockets.BungeeSockets;
import me.limeglass.skungee.bungeecord.sockets.ServerTracker;
import me.limeglass.skungee.bungeecord.variables.SkungeeStorage;
import me.limeglass.skungee.objects.SkungeeVariable;
import me.limeglass.skungee.objects.packets.BungeePacket;
import me.limeglass.skungee.objects.packets.BungeePacketType;

public class FlatFileStorage
extends SkungeeStorage {
    private final String DELIMITER = "@: ";
    private boolean loadingHash = false;
    private File folder;
    private File file;
    private FileWriter writer;
    private Gson gson;

    public FlatFileStorage() {
        super("CSV", "flatfile");
    }

    private void header() throws IOException {
        this.writer.append("\n");
        this.writer.append("# Skungee's variable database.");
        this.writer.append("\n");
        this.writer.append("# Please do not modify this file manually, thank you!");
        this.writer.append("\n");
        this.writer.append("\n");
    }

    @Override
    public boolean initialize() {
        this.gson = new GsonBuilder().setLenient().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).create();
        this.file = new File(variablesFolder + "variables.csv");
        this.folder = new File(variablesFolder);
        this.folder.mkdir();
        if (!this.file.exists()) {
            try {
                this.writer = new FileWriter(this.file);
                this.header();
                this.writer.flush();
                Skungee.debugMessage("Successfully created CSV variables database!");
            }
            catch (IOException e) {
                Skungee.exception(e, "Failed to create a CSV variable database.");
                return false;
            }
        } else {
            this.load();
        }
        return true;
    }

    @Override
    public SkungeeVariable.Value[] get(String index) {
        if (index.endsWith("::*")) {
            ArrayList<SkungeeVariable.Value> values = new ArrayList<SkungeeVariable.Value>();
            index = index.substring(0, index.length() - 1);
            for (Map.Entry entry : variables.entrySet()) {
                SkungeeVariable.Value[] data;
                if (!((String)entry.getKey()).startsWith(index) || (data = (SkungeeVariable.Value[])variables.get(entry.getKey())) == null) continue;
                for (SkungeeVariable.Value value : data) {
                    values.add(value);
                }
            }
            SkungeeVariable.Value[] data = (SkungeeVariable.Value[])variables.get(index);
            if (data != null) {
                for (SkungeeVariable.Value value : data) {
                    values.add(value);
                }
            }
            return values.toArray(new SkungeeVariable.Value[values.size()]);
        }
        return (SkungeeVariable.Value[])variables.get(index);
    }

    @Override
    public void delete(String ... indexes) {
        ArrayList list = Lists.newArrayList((Object[])indexes);
        for (String index : indexes) {
            if (!index.endsWith("::*")) continue;
            String varIndex = index.substring(0, index.length() - 1);
            for (Map.Entry entry : variables.entrySet()) {
                if (!((String)entry.getKey()).startsWith(varIndex)) continue;
                list.add(entry.getKey());
            }
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            Skungee.exception(e, "Failed to close writer for removing index");
        }
        for (String index : list) {
            if (!variables.containsKey(index) || this.loadingHash) continue;
            variables.remove(index);
        }
        this.loadFromHash();
    }

    @Override
    public void remove(SkungeeVariable.Value[] objects, String ... indexes) {
        ArrayList list = Lists.newArrayList((Object[])indexes);
        for (String index : indexes) {
            if (!index.endsWith("::*")) continue;
            index = index.substring(0, index.length() - 1);
            for (Map.Entry entry : variables.entrySet()) {
                if (!((String)entry.getKey()).startsWith(index)) continue;
                list.add(entry.getKey());
            }
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            Skungee.exception(e, "Failed to close writer for removing index");
        }
        for (String index : list) {
            Object[] v;
            if (!variables.containsKey(index) && this.loadingHash || (v = (SkungeeVariable.Value[])variables.get(index)) == null) continue;
            ArrayList values = Lists.newArrayList((Object[])v);
            for (Object value : v) {
                for (SkungeeVariable.Value object : objects) {
                    if (!((SkungeeVariable.Value)value).isSimilar(object)) continue;
                    values.remove(value);
                }
            }
            if (values.isEmpty()) {
                variables.remove(index);
                continue;
            }
            variables.put(index, values.toArray(new SkungeeVariable.Value[values.size()]));
        }
        this.loadFromHash();
    }

    @Override
    public void backup() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            Skungee.exception(e, "Error closing the variable flatfile writter");
        }
        Date date = new Date();
        new File(this.folder + File.separator + "backups" + File.separator).mkdir();
        File newFile = new File(this.folder + File.separator + "backups" + File.separator + date.toString().replaceAll(":", "-") + ".csv");
        try {
            Files.copy(this.file.toPath(), newFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Skungee.exception(e, "Failed to backup flatfile");
        }
        this.load();
    }

    private void load() {
        String line = "";
        BufferedReader reader = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            reader = new BufferedReader(new FileReader(this.file));
            for (int i = 0; i < 4; ++i) {
                reader.readLine();
            }
            while ((line = reader.readLine()) != null) {
                String[] values = line.split("@: ", 2);
                if (values.length != 2) continue;
                map.put(values[0], values[1]);
            }
            this.writer = new FileWriter(this.file);
            this.header();
            for (Map.Entry data : map.entrySet()) {
                SkungeeVariable.Value[] values = (SkungeeVariable.Value[])this.gson.fromJson((String)data.getValue(), SkungeeVariable.Value[].class);
                this.set((String)data.getKey(), values);
            }
            reader.close();
        }
        catch (IOException e) {
            Skungee.exception(e, "Failed to load and write variables.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String name, SkungeeVariable.Value[] values) {
        if (Skungee.getConfig().getBoolean("NetworkVariables.AutomaticSharing", false) && !ServerTracker.isEmpty().booleanValue()) {
            BungeeSockets.sendAll(new BungeePacket((Boolean)false, BungeePacketType.UPDATEVARIABLES, (Object)name, values));
        }
        if (variables.containsKey(name) && !this.loadingHash) {
            if (!Skungee.getConfig().getBoolean("NetworkVariables.AllowOverrides", true)) {
                return;
            }
            try {
                this.writer.close();
            }
            catch (IOException e) {
                Skungee.exception(e, "Failed to close the writer while setting the value: " + name);
            }
            variables.remove(name);
            this.loadFromHash();
        }
        variables.put(name, values);
        try {
            this.writer.append(name);
            this.writer.append("@: ");
            this.writer.append(this.gson.toJson((Object)values));
            this.writer.append("\n");
        }
        catch (IOException e) {
            try {
                this.writer = new FileWriter(this.file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                Skungee.debugMessage("Error flushing data while writing!");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadFromHash() {
        block12: {
            block11: {
                this.loadingHash = true;
                this.writer = new FileWriter(this.file);
                this.header();
                if (variables.isEmpty()) break block11;
                ArrayList ids = Lists.newArrayList(variables.keySet());
                for (String ID : ids) {
                    this.set(ID, (SkungeeVariable.Value[])variables.get(ID));
                }
            }
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                Skungee.exception(e, "Error flushing writer while loading from hash!");
            }
            break block12;
            catch (IOException e) {
                try {
                    Skungee.exception(e, "Error flushing writer while loading from hash!");
                }
                catch (Throwable throwable) {
                    try {
                        this.writer.flush();
                    }
                    catch (IOException e2) {
                        Skungee.exception(e2, "Error flushing writer while loading from hash!");
                    }
                    throw throwable;
                }
                try {
                    this.writer.flush();
                }
                catch (IOException e3) {
                    Skungee.exception(e3, "Error flushing writer while loading from hash!");
                }
            }
        }
        this.loadingHash = false;
    }

    static {
        FlatFileStorage.registerStorage(new FlatFileStorage());
    }
}

