/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.handlercontroller;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.objects.packets.SkungeePacketType;

public abstract class SkungeeHandler {
    protected SkungeePacketType[] types = new SkungeePacketType[]{SkungeePacketType.CUSTOM};
    protected static Set<SkungeeHandler> registered = new HashSet<SkungeeHandler>();
    protected SkungeePacket packet;
    protected InetAddress address;
    protected String name;

    protected static void registerHandler(SkungeeHandler handler, String name) {
        handler.setName(name);
        if (!registered.contains(handler)) {
            registered.add(handler);
        }
    }

    protected static void registerHandler(SkungeeHandler handler, SkungeePacketType ... types) {
        handler.setTypes(types);
        for (SkungeePacketType type : types) {
            SkungeeHandler.registerHandler(handler, type.name());
        }
    }

    public static <T> Optional<T> getHandler(Class<? extends SkungeeHandler> type) {
        return registered.parallelStream().filter(handler -> type.isAssignableFrom(handler.getClass())).findFirst();
    }

    public static Optional<SkungeeHandler> getHandler(SkungeePacketType type) {
        for (SkungeeHandler handler : registered) {
            for (SkungeePacketType packetType : handler.getTypes()) {
                if (packetType != type) continue;
                return Optional.of(handler);
            }
        }
        return Optional.empty();
    }

    public static Optional<SkungeeHandler> getHandler(String name) {
        return registered.parallelStream().filter(handler -> handler.getName().equals(name)).findFirst();
    }

    public void setTypes(SkungeePacketType ... types) {
        this.types = types;
    }

    public SkungeePacketType[] getTypes() {
        return this.types;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract boolean onPacketCall(SkungeePacket var1, InetAddress var2);

    public abstract Object handlePacket(SkungeePacket var1, InetAddress var2);

    public Object callPacket(SkungeePacket packet, InetAddress address) {
        this.packet = packet;
        this.address = address;
        String string = this.toString(packet);
        if (string != null) {
            Skungee.debugMessage("Recieved " + string);
        }
        if (!this.onPacketCall(packet, address)) {
            return null;
        }
        return this.handlePacket(packet, address);
    }

    protected String toString(SkungeePacket packet) {
        return UniversalSkungee.getPacketDebug(packet);
    }
}

