/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.util.StringMode;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import me.limeglass.skungee.objects.SkriptChangeMode;
import me.limeglass.skungee.objects.SkungeePacket;
import me.limeglass.skungee.objects.SkungeePacketType;
import me.limeglass.skungee.spigot.Skungee;
import me.limeglass.skungee.spigot.lang.SkungeeExpression;
import me.limeglass.skungee.spigot.sockets.Sockets;
import me.limeglass.skungee.spigot.utils.Utils;
import me.limeglass.skungee.spigot.utils.annotations.AllChangers;
import me.limeglass.skungee.spigot.utils.annotations.ExpressionProperty;
import me.limeglass.skungee.spigot.utils.annotations.Patterns;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Network variable")
@Description(value={"Returns a variable that is stored on the Bungeecord, can also be set, add, removed etc."})
@Patterns(value={"[the] [skungee] (global|network|bungee[[ ]cord]) variable [(from|of)] %object%"})
@ExpressionProperty(value=ExpressionType.COMBINED)
@AllChangers
public class ExprNetworkVariable
extends SkungeeExpression<Object> {
    private static Variable variable;
    private VariableString variableString;

    @Override
    public boolean isSingle() {
        return !variable.isList();
    }

    @Override
    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        if (expressions[0] instanceof Variable) {
            variable = (Variable)expressions[0];
            if (variable.isLocal()) {
                Skript.error((String)"Network Variables can not be a local variable.");
                return false;
            }
            String var = variable.toString().substring(1, variable.toString().length() - 1);
            this.variableString = VariableString.newInstance((String)var, (StringMode)StringMode.VARIABLE_NAME);
            return true;
        }
        Skript.error((String)"Network Variables must be in a variable format!");
        return false;
    }

    @Nullable
    protected Object[] get(Event event) {
        Object object = Sockets.send((SkungeePacket)new SkungeePacket(Boolean.valueOf(true), SkungeePacketType.NETWORKVARIABLE, (Object)this.variableString.toString(event)));
        if (object instanceof ArrayList) {
            ArrayList list = (ArrayList)object;
            Object[] array = new Object[list.size()];
            int i = 0;
            for (Object obj : list) {
                array[i] = obj;
                ++i;
            }
            return array;
        }
        Object[] var = (Object[])object;
        return var != null ? var : null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        SkriptChangeMode changer = Utils.getEnum(SkriptChangeMode.class, mode.toString());
        if (changer == null) {
            return;
        }
        if (!variable.isList() && changer == SkriptChangeMode.ADD || changer == SkriptChangeMode.REMOVE || changer == SkriptChangeMode.REMOVE_ALL) {
            Skungee.consoleMessage("You can only remove, add and remove all from list variables.");
            return;
        }
        Sockets.send((SkungeePacket)new SkungeePacket(Boolean.valueOf(false), SkungeePacketType.NETWORKVARIABLE, (Object)this.variableString.toString(event), (Object)delta, changer));
    }
}

