/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.sockets;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.sockets.ServerTracker;
import me.limeglass.skungee.objects.BungeePacket;
import me.limeglass.skungee.objects.BungeePacketType;
import me.limeglass.skungee.objects.ConnectedServer;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeeSockets {
    private static Boolean checking = false;
    public static Socket spigot = null;
    public static Map<InetAddress, Integer> attempts = new HashMap<InetAddress, Integer>();
    public static Set<InetAddress> blocked = new HashSet<InetAddress>();

    private static Socket getSocketConnection(ConnectedServer server) {
        for (int i = 0; i < Skungee.getConfig().getInt("Recievers.allowedTrys", 5); ++i) {
            try {
                return new Socket(server.getAddress(), (int)server.getRecieverPort());
            }
            catch (IOException iOException) {
                continue;
            }
        }
        Skungee.consoleMessage("Could not establish a connection to the reciever on server: " + server.getName());
        return null;
    }

    public static Object send(ConnectedServer server, BungeePacket packet) {
        if (server == null) {
            Skungee.consoleMessage("The server argument was incorrect or not set while sending bungee " + UniversalSkungee.getPacketDebug((BungeePacket)packet));
            return null;
        }
        if (ServerTracker.isResponding(server).booleanValue() && server.hasReciever().booleanValue() && !checking.booleanValue()) {
            checking = true;
            spigot = BungeeSockets.getSocketConnection(server);
            if (spigot == null) {
                return null;
            }
            checking = false;
            if (!Skungee.getConfig().getBoolean("IgnoreSpamPackets", true)) {
                Skungee.debugMessage("Sending " + UniversalSkungee.getPacketDebug((BungeePacket)packet) + " to server: " + server.getName());
            } else if (packet.getType() != BungeePacketType.GLOBALSCRIPTS) {
                Skungee.debugMessage("Sending " + UniversalSkungee.getPacketDebug((BungeePacket)packet) + " to server: " + server.getName());
            }
            if (Skungee.getConfig().getBoolean("security.password.enabled", false)) {
                byte[] password = Skungee.getEncrypter().serialize(Skungee.getConfig().getString("security.password.password"));
                if (Skungee.getConfig().getBoolean("security.password.hash", true)) {
                    password = Skungee.getConfig().getBoolean("security.password.hashFile", false) && Skungee.getEncrypter().isFileHashed() != false ? Skungee.getEncrypter().getHashFromFile() : Skungee.getEncrypter().hash();
                }
                if (password != null) {
                    packet.setPassword(password);
                }
            }
            try {
                spigot.setSoTimeout(10000);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(spigot.getOutputStream());
                if (Skungee.getConfig().getBoolean("security.encryption.enabled", false)) {
                    byte[] serialized = Skungee.getEncrypter().serialize(packet);
                    objectOutputStream.writeObject(Base64.getEncoder().encode(serialized));
                } else {
                    objectOutputStream.writeObject(packet);
                }
                ObjectInputStream objectInputStream = new ObjectInputStream(spigot.getInputStream());
                if (packet.isReturnable().booleanValue()) {
                    if (Skungee.getConfig().getBoolean("security.encryption.enabled", false)) {
                        byte[] decoded = Base64.getDecoder().decode((byte[])objectInputStream.readObject());
                        return Skungee.getEncrypter().deserialize(decoded);
                    }
                    return objectInputStream.readObject();
                }
                objectOutputStream.close();
                objectInputStream.close();
                spigot.close();
            }
            catch (IOException | ClassNotFoundException exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<Object> send(BungeePacket packet, ConnectedServer ... servers) {
        if (packet.isReturnable().booleanValue()) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (ConnectedServer server : servers) {
                values.add(BungeeSockets.send((ConnectedServer)server, (BungeePacket)packet));
            }
            return values;
        }
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)Skungee.getInstance(), new Runnable(servers, packet){

            @Override
            public void run() {
                StringBuilder builder = new StringBuilder();
                boolean found = false;
                ConnectedServer[] connectedServerArray = servers;
                int n = servers.length;
                int n2 = 0;
                while (n2 < n) {
                    ConnectedServer server = connectedServerArray[n2];
                    if (server != null) {
                        builder.append(String.valueOf(server.getName()) + "-" + server.getAddress() + ":" + server.getPort());
                        if (packet != null) {
                            found = true;
                            BungeeSockets.send(server, packet);
                        }
                    }
                    ++n2;
                }
                if (!found) {
                    Skungee.debugMessage("Could not find servers by the names: " + builder.toString());
                }
            }
        });
        return null;
    }

    public static List<Object> sendAll(BungeePacket packet) {
        if (packet.isReturnable().booleanValue()) {
            return ServerTracker.getAll().parallelStream().filter(server -> server.hasReciever()).map(server -> BungeeSockets.send((ConnectedServer)server, (BungeePacket)packet)).collect(Collectors.toList());
        }
        ProxyServer.getInstance().getScheduler().runAsync((Plugin)Skungee.getInstance(), new Runnable(packet){

            @Override
            public void run() {
                for (ConnectedServer server : ServerTracker.getAll()) {
                    if (!server.hasReciever().booleanValue()) continue;
                    BungeeSockets.send(server, packet);
                }
            }
        });
        return null;
    }

    public static Object[] get(BungeePacket packet, ConnectedServer ... servers) {
        Object[] returns = null;
        int i = 0;
        for (ConnectedServer server : servers) {
            returns[i] = BungeeSockets.send((ConnectedServer)server, (BungeePacket)packet);
            ++i;
        }
        return returns != null ? returns : null;
    }
}

