/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.handlers;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import me.limeglass.skungee.bungeecord.handlercontroller.SkungeeBungeeHandler;
import me.limeglass.skungee.bungeecord.handlercontroller.SkungeeHandler;
import me.limeglass.skungee.bungeecord.variables.VariableManager;
import me.limeglass.skungee.objects.SkungeeEnums;
import me.limeglass.skungee.objects.SkungeeVariable;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.objects.packets.SkungeePacketType;

public class NetworkVariableHandler
extends SkungeeBungeeHandler {
    static {
        NetworkVariableHandler.registerHandler((SkungeeHandler)new NetworkVariableHandler(), SkungeePacketType.NETWORKVARIABLE);
    }

    public SkungeeVariable.Value[] handlePacket(SkungeePacket packet, InetAddress address) {
        Object object = packet.getObject();
        if (object == null) {
            return null;
        }
        if (object instanceof SkungeeVariable) {
            SkungeeVariable variable = (SkungeeVariable)object;
            String variableString = variable.getVariableString();
            SkungeeVariable.Value[] values = variable.getValues();
            if (variableString == null) {
                return null;
            }
            SkungeeEnums.SkriptChangeMode mode = packet.getChangeMode();
            if (mode != null) {
                ArrayList modify = new ArrayList();
                Object[] data = VariableManager.getMainStorage().get(variableString);
                if (data != null) {
                    modify = Lists.newArrayList((Object[])data);
                }
                if (values == null && mode != SkungeeEnums.SkriptChangeMode.RESET && mode != SkungeeEnums.SkriptChangeMode.DELETE) {
                    return null;
                }
                switch (mode) {
                    case ADD: {
                        VariableManager.getMainStorage().delete(variableString);
                        SkungeeVariable.Value[] valueArray = values;
                        int n = values.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SkungeeVariable.Value value = valueArray[n2];
                            modify.add(value);
                            ++n2;
                        }
                        VariableManager.getMainStorage().set(variableString, modify.toArray(new SkungeeVariable.Value[modify.size()]));
                        break;
                    }
                    case REMOVE: 
                    case REMOVE_ALL: {
                        VariableManager.getMainStorage().remove(values, variableString);
                        break;
                    }
                    case DELETE: 
                    case RESET: {
                        VariableManager.getMainStorage().delete(variableString);
                        break;
                    }
                    case SET: {
                        VariableManager.getMainStorage().set(variableString, values);
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (object instanceof String && packet.getChangeMode() == null) {
            return VariableManager.getMainStorage().get((String)object);
        }
        return null;
    }
}

