/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.sockets.BungeeSockets;
import me.limeglass.skungee.bungeecord.sockets.ServerTracker;
import me.limeglass.skungee.objects.BungeePacket;
import me.limeglass.skungee.objects.BungeePacketType;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Plugin;

/*
 * Exception performing whole class analysis ignored.
 */
public class VariableStorage {
    private static final String folder = Skungee.getInstance().getDataFolder().getAbsolutePath() + File.separator + "variables" + File.separator;
    private static TreeMap<String, Object> variables = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private static final GsonBuilder gsonBuilder = new GsonBuilder();
    private static final String DELIMITER = ": ";
    private static final String NEW_LINE = "\n";
    private static Boolean loadingHash = false;
    private static FileWriter writer = null;
    private static Gson gson;
    private static File file;

    public static FileWriter getWriter() {
        return writer;
    }

    public static Object get(String ID) {
        return variables.get(ID);
    }

    public static Integer getSize() {
        return variables.size();
    }

    public static void save(Boolean running, Boolean reboot) {
        if (running.booleanValue()) {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Date date = new Date();
        new File(folder + File.separator + "backups" + File.separator).mkdir();
        File newFile = new File(folder + File.separator + "backups" + File.separator + date.toString().replaceAll(":", "-") + ".csv");
        try {
            Files.copy(file.toPath(), newFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (reboot.booleanValue()) {
            VariableStorage.load();
        }
    }

    public static void setup() {
        if (Skungee.getConfig().getBoolean("NetworkVariables.Backups.Enabled", false)) {
            VariableStorage.run();
        }
        new File(folder).mkdir();
        file = new File(folder + "variables.csv");
        gsonBuilder.setFieldNamingPolicy(FieldNamingPolicy.IDENTITY);
        gson = gsonBuilder.create();
        if (!file.exists()) {
            try {
                writer = new FileWriter(file);
                writer.append("\n");
                writer.append("# Skungee's variable database.");
                writer.append("\n");
                writer.append("# Please do not modify this file manually, thank you!");
                writer.append("\n");
                writer.append("\n");
                Skungee.debugMessage("Successfully created CSV variables database!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    writer.flush();
                }
                catch (IOException e) {
                    Skungee.debugMessage("Error flushing data during setup!");
                    e.printStackTrace();
                }
            }
        } else {
            VariableStorage.load();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load() {
        String line = "";
        BufferedReader reader = null;
        try {
            ArrayList<String[]> data = new ArrayList<String[]>();
            reader = new BufferedReader(new FileReader(file));
            for (int i = 0; i < 4; ++i) {
                reader.readLine();
            }
            while ((line = reader.readLine()) != null) {
                String[] values = line.split(": ", 2);
                data.add(values);
            }
            writer = new FileWriter(file);
            writer.append("\n");
            writer.append("# Skungee's variable database.");
            writer.append("\n");
            writer.append("# Please do not modify this file manually, thank you!");
            writer.append("\n");
            writer.append("\n");
            for (String[] varaibleData : data) {
                VariableStorage.write((String)varaibleData[0], (Object)gson.fromJson(varaibleData[1], Object.class));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                Skungee.debugMessage("Error closing reader while loading!");
                e.printStackTrace();
            }
        }
    }

    private static void loadFromHash() {
        loadingHash = true;
        try {
            writer = new FileWriter(file);
            writer.append("\n");
            writer.append("# Skungee's variable database.");
            writer.append("\n");
            writer.append("# Please do not modify this file manually, thank you!");
            writer.append("\n");
            writer.append("\n");
            if (!variables.isEmpty()) {
                for (String ID : variables.keySet()) {
                    VariableStorage.write((String)ID, variables.get(ID));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException e) {
                Skungee.debugMessage("Error flushing writer while loading from hash!");
                e.printStackTrace();
            }
        }
        loadingHash = false;
    }

    public static void remove(String ID) {
        if (variables.containsKey(ID) && !loadingHash.booleanValue()) {
            try {
                VariableStorage.getWriter().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            variables.remove(ID);
            VariableStorage.loadFromHash();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String ID, Object object) {
        if (ID == null || object == null) {
            return;
        }
        if (Skungee.getConfig().getBoolean("NetworkVariables.AutomaticSharing", false) && !ServerTracker.isEmpty().booleanValue()) {
            BungeePacket packet = new BungeePacket(Boolean.valueOf(false), BungeePacketType.UPDATEVARIABLES, (Object)ID, object);
            BungeeSockets.sendAll((BungeePacket)packet);
        }
        if (variables.containsKey(ID) && !loadingHash.booleanValue()) {
            if (Skungee.getConfig().getBoolean("NetworkVariables.AllowOverrides", true)) {
                try {
                    VariableStorage.getWriter().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                variables.remove(ID);
                VariableStorage.loadFromHash();
            } else {
                return;
            }
        }
        variables.put(ID, object);
        try {
            writer.append(ID);
            writer.append(": ");
            writer.append(gson.toJson(object));
            writer.append("\n");
        }
        catch (IOException e) {
            try {
                writer = new FileWriter(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException e) {
                Skungee.debugMessage("Error flushing data while writing!");
                e.printStackTrace();
            }
        }
    }

    public static void run() {
        Long time = Skungee.getConfig().getLong("NetworkVariables.Backups.IntervalTime", 120L);
        ProxyServer.getInstance().getScheduler().schedule((Plugin)Skungee.getInstance(), (Runnable)new /* Unavailable Anonymous Inner Class!! */, time.longValue(), time.longValue(), TimeUnit.MINUTES);
    }
}

