/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.spigot;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import me.limeglass.skungee.EncryptionUtil;
import me.limeglass.skungee.objects.SkungeePacket;
import me.limeglass.skungee.objects.SkungeePacketType;
import me.limeglass.skungee.spigot.Metrics;
import me.limeglass.skungee.spigot.elements.Register;
import me.limeglass.skungee.spigot.sockets.PacketQueue;
import me.limeglass.skungee.spigot.sockets.Reciever;
import me.limeglass.skungee.spigot.sockets.Sockets;
import me.limeglass.skungee.spigot.utils.ReflectionUtil;
import me.limeglass.skungee.spigot.utils.Utils;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;

public class Skungee
extends JavaPlugin {
    private static Map<String, FileConfiguration> files = new HashMap<String, FileConfiguration>();
    private String packageName = "me.limeglass.skungee.spigot";
    private static String prefix = "&8[&cSkungee&8] &e";
    private static String nameplate = "[Skungee] ";
    private EncryptionUtil encryption;
    private static Skungee instance;
    private SkriptAddon addon;
    private Metrics metrics;

    public void onEnable() {
        this.addon = Skript.registerAddon((JavaPlugin)this).setLanguageFileDirectory("lang");
        instance = this;
        this.saveDefaultConfig();
        File config = new File(this.getDataFolder(), "config.yml");
        if (!Objects.equals(this.getDescription().getVersion(), this.getConfig().getString("version"))) {
            Skungee.consoleMessage("&dNew update found! Updating files now...");
            if (config.exists()) {
                config.delete();
            }
        }
        for (String name : Arrays.asList("config", "syntax")) {
            File file = new File(this.getDataFolder(), name + ".yml");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                this.saveResource(file.getName(), false);
            }
            YamlConfiguration configuration = new YamlConfiguration();
            try {
                configuration.load(file);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
            files.put(name, (FileConfiguration)configuration);
        }
        this.encryption = new EncryptionUtil(this, (Boolean)true);
        this.encryption.hashFile();
        if (this.getConfig().getBoolean("Queue.enabled", true)) {
            PacketQueue.start();
        }
        this.metrics = new Metrics(this);
        Register.metrics(this.metrics);
        if (this.getConfig().getBoolean("Reciever.enabled", false)) {
            Reciever.setupReciever();
        } else {
            Sockets.connect();
        }
        if (!this.getConfig().getBoolean("DisableRegisteredInfo", false)) {
            Bukkit.getLogger().info(nameplate + "has been enabled!");
        }
    }

    public void onDisable() {
        Sockets.send((SkungeePacket)new SkungeePacket(Boolean.valueOf(true), SkungeePacketType.DISCONNECT, (Object)Bukkit.getPort()));
        PacketQueue.stop();
        Sockets.onPluginDisabling();
    }

    public static final void exception(Throwable cause, String ... info) {
        HashMap<String, PluginDescriptionFile> plugins = new HashMap<String, PluginDescriptionFile>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            if (plugin.getDescription().getName().equals("Skungee")) continue;
            String[] parts = plugin.getDescription().getMain().split("\\.");
            StringBuilder name = new StringBuilder(plugin.getDescription().getMain().length());
            for (int i = 0; i < parts.length - 1; ++i) {
                name.append(parts[i]).append('.');
            }
            plugins.put(name.toString(), plugin.getDescription());
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage(Skungee.getNameplate() + "Severe Error:");
        Skungee.infoMessage(info);
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Something went wrong within Skungee.");
        Skungee.infoMessage("Please report this error to the developers of Skungee so we can fix this from happening in the future.");
        HashSet stackPlugins = new HashSet();
        for (StackTraceElement stackTrace : Thread.currentThread().getStackTrace()) {
            for (Map.Entry entry : plugins.entrySet()) {
                if (!stackTrace.getClassName().contains((CharSequence)entry.getKey())) continue;
                stackPlugins.add(entry.getValue());
            }
        }
        if (!stackPlugins.isEmpty()) {
            Skungee.infoMessage(new String[0]);
            Skungee.infoMessage("It looks like you are using some plugin(s) that aren't allowing Skungee to work properly.");
            Skungee.infoMessage("Following plugins are probably related to this error in some way:");
            StringBuilder pluginsMessage = new StringBuilder();
            for (PluginDescriptionFile desc : stackPlugins) {
                pluginsMessage.append(desc.getName());
                pluginsMessage.append(" ");
            }
            Skungee.infoMessage(pluginsMessage.toString());
            Skungee.infoMessage("You should try disabling those plugins one by one, trying to find which one causes it.");
            Skungee.infoMessage("If the error doesn't disappear even after disabling all listed plugins, it is probably a Skungee issue.");
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Please report this on the Skungee discussion page on SkUnity or Spigot", "You can also message one of the Skungee developers this error.");
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Stack trace:");
        boolean first = true;
        while (cause != null) {
            Skungee.infoMessage((first ? "" : "Caused by: ") + cause.toString());
            for (StackTraceElement e : cause.getStackTrace()) {
                Skungee.infoMessage("    at " + e.toString());
            }
            cause = cause.getCause();
            first = false;
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Information:");
        Skungee.infoMessage("  Skungee: " + Skungee.getInstance().getConfig().getString("version"));
        Skungee.infoMessage("  Bukkit: " + Bukkit.getBukkitVersion());
        Skungee.infoMessage("  Minecraft: " + ReflectionUtil.getVersion());
        Skungee.infoMessage("  Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ")");
        Skungee.infoMessage("  OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Running CraftBukkit: " + Skript.isRunningCraftBukkit());
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Thread: " + Thread.currentThread());
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("End of Error.");
        Skungee.infoMessage(new String[0]);
    }

    public static Skungee getInstance() {
        return instance;
    }

    public EncryptionUtil getEncrypter() {
        return this.encryption;
    }

    public SkriptAddon getAddonInstance() {
        return this.addon;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public static String getNameplate() {
        return nameplate;
    }

    public static String getPrefix() {
        return prefix;
    }

    public static FileConfiguration getConfiguration(String file) {
        return files.containsKey(file) ? files.get(file) : null;
    }

    public static void save(String configuration) {
        try {
            File configurationFile = new File(instance.getDataFolder(), configuration + ".yml");
            Skungee.getConfiguration(configuration).save(configurationFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void debugMessage(String ... messages) {
        if (instance.getConfig().getBoolean("debug")) {
            for (String text : messages) {
                Skungee.consoleMessage("&b" + text);
            }
        }
    }

    public static void infoMessage(String ... messages) {
        if (messages != null && messages.length > 0) {
            for (String text : messages) {
                Bukkit.getLogger().info(Skungee.getNameplate() + text);
            }
        } else {
            Bukkit.getLogger().info("");
        }
    }

    public static void consoleMessage(String ... messages) {
        if (instance.getConfig().getBoolean("DisableConsoleMessages", false)) {
            return;
        }
        if (messages != null && messages.length > 0) {
            for (String text : messages) {
                if (instance.getConfig().getBoolean("DisableConsoleColour", false)) {
                    Skungee.infoMessage(ChatColor.stripColor((String)Utils.cc(text)));
                    continue;
                }
                Bukkit.getConsoleSender().sendMessage(Utils.cc(prefix + text));
            }
        } else {
            Bukkit.getLogger().info("");
        }
    }
}

