/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.handlers;

import com.imaginarycode.minecraft.redisbungee.RedisBungee;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.sockets.BungeeSockets;
import me.limeglass.skungee.bungeecord.sockets.ServerInstancesSockets;
import me.limeglass.skungee.bungeecord.sockets.ServerTracker;
import me.limeglass.skungee.objects.ConnectedServer;
import me.limeglass.skungee.objects.SkungeeEnums;
import me.limeglass.skungee.objects.SkungeePlayer;
import me.limeglass.skungee.objects.packets.BungeePacket;
import me.limeglass.skungee.objects.packets.BungeePacketType;
import me.limeglass.skungee.objects.packets.ServerInstancesPacket;
import me.limeglass.skungee.objects.packets.ServerInstancesPacketType;
import me.limeglass.skungee.objects.packets.SkungeePacket;
import me.limeglass.skungee.spigot.utils.Utils;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;

public class SkungeePacketHandler {
    public static Object handlePacket(SkungeePacket packet, InetAddress address) {
        Skungee.debugMessage("Recieved " + UniversalSkungee.getPacketDebug(packet));
        ArrayList<ProxiedPlayer> players = new ArrayList<ProxiedPlayer>();
        if (packet.getPlayers() != null) {
            SkungeePlayer[] skungeePlayerArray = packet.getPlayers();
            int n = skungeePlayerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SkungeePlayer player = skungeePlayerArray[n2];
                ProxiedPlayer proxiedPlayer = null;
                if (Skungee.getConfig().getBoolean("IncomingUUIDs", true) && player.getUUID() != null) {
                    proxiedPlayer = ProxyServer.getInstance().getPlayer(player.getUUID());
                    if (proxiedPlayer == null) {
                        proxiedPlayer = ProxyServer.getInstance().getPlayer(player.getName());
                    }
                } else if (player.getName() != null) {
                    proxiedPlayer = ProxyServer.getInstance().getPlayer(player.getName());
                }
                if (proxiedPlayer != null) {
                    players.add(proxiedPlayer);
                }
                ++n2;
            }
        }
        Map servers = ProxyServer.getInstance().getServers();
        switch (packet.getType()) {
            case KICKPLAYERS: {
                String message = "Kicked from the bungeecord network.";
                if (packet.getObject() != null) {
                    message = (String)packet.getObject();
                } else if (Skungee.getConfig().getBoolean("Misc.UseFunnyKickMessages")) {
                    List messages = Skungee.getConfig().getStringList("Misc.FunnyKickMessages");
                    Collections.shuffle(messages);
                    message = (String)messages.get(0);
                }
                for (ProxiedPlayer p : ProxyServer.getInstance().getPlayers()) {
                    p.disconnect((BaseComponent)new TextComponent(message));
                }
                break;
            }
            case KICKPLAYER: {
                if (players.isEmpty()) break;
                String msg = "Kicked from the bungeecord network.";
                if (packet.getObject() != null) {
                    msg = (String)packet.getObject();
                } else if (Skungee.getConfig().getBoolean("Misc.UseFunnyKickMessages")) {
                    List messages = Skungee.getConfig().getStringList("Misc.FunnyKickMessages");
                    Collections.shuffle(messages);
                    msg = (String)messages.get(0);
                }
                for (ProxiedPlayer player : players) {
                    player.disconnect((BaseComponent)new TextComponent(msg));
                }
                break;
            }
            case BUNGEECOMMAND: {
                if (packet.getObject() == null) break;
                if ((Long)packet.getSetObject() > 0L) {
                    int multiplier = 1;
                    String[] stringArray = (String[])packet.getObject();
                    int n = stringArray.length;
                    int proxiedPlayer = 0;
                    while (proxiedPlayer < n) {
                        String command = stringArray[proxiedPlayer];
                        if (command.startsWith("/")) {
                            command = command.substring(1);
                        }
                        final String intoRunnable = command;
                        ProxyServer.getInstance().getScheduler().schedule((Plugin)Skungee.getInstance(), new Runnable(){

                            @Override
                            public void run() {
                                ProxyServer.getInstance().getPluginManager().dispatchCommand(ProxyServer.getInstance().getConsole(), intoRunnable);
                            }
                        }, (Long)packet.getSetObject() * (long)multiplier, TimeUnit.MILLISECONDS);
                        ++multiplier;
                        ++proxiedPlayer;
                    }
                } else {
                    String[] stringArray = (String[])packet.getObject();
                    int proxiedPlayer = stringArray.length;
                    int command = 0;
                    while (command < proxiedPlayer) {
                        String command2 = stringArray[command];
                        if (command2.startsWith("/")) {
                            command2 = command2.substring(1);
                        }
                        ProxyServer.getInstance().getPluginManager().dispatchCommand(ProxyServer.getInstance().getConsole(), command2);
                        ++command;
                    }
                }
                break;
            }
            case PROXYSTOP: {
                if (packet.getObject() != null) {
                    String msg = (String)packet.getObject();
                    ProxyServer.getInstance().stop(msg);
                    break;
                }
                ProxyServer.getInstance().stop();
                break;
            }
            case GLOBALPLAYERS: {
                HashSet<SkungeePlayer> allPlayers = new HashSet<SkungeePlayer>();
                for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
                    allPlayers.add(new SkungeePlayer(false, player.getUniqueId(), player.getName()));
                }
                return allPlayers;
            }
            case SERVERPLAYERS: {
                if (packet.getObject() == null) break;
                HashSet<SkungeePlayer> skungeePlayers = new HashSet<SkungeePlayer>();
                String[] intoRunnable = (String[])packet.getObject();
                int n = intoRunnable.length;
                int n3 = 0;
                while (n3 < n) {
                    String server = intoRunnable[n3];
                    if (ProxyServer.getInstance().getServerInfo(server) != null) {
                        for (ProxiedPlayer player : ProxyServer.getInstance().getServerInfo(server).getPlayers()) {
                            skungeePlayers.add(new SkungeePlayer(false, player.getUniqueId(), player.getName()));
                        }
                    }
                    ++n3;
                }
                return skungeePlayers;
            }
            case ALLSERVERS: {
                HashSet<String> allservers = new HashSet<String>();
                for (Map.Entry entry : servers.entrySet()) {
                    allservers.add((String)entry.getKey());
                }
                return allservers;
            }
            case SERVERIP: {
                if (packet.getObject() == null) break;
                HashSet<String> addresses = new HashSet<String>();
                String[] player = (String[])packet.getObject();
                int intoRunnable = player.length;
                int n = 0;
                while (n < intoRunnable) {
                    String server = player[n];
                    ServerInfo serverAddress = ProxyServer.getInstance().getServerInfo(server);
                    if (serverAddress != null) {
                        addresses.add(serverAddress.getAddress().getHostName());
                    }
                    ++n;
                }
                return addresses;
            }
            case SERVERMOTD: {
                if (packet.getObject() == null) break;
                HashSet<String> motds = new HashSet<String>();
                String[] player = (String[])packet.getObject();
                int intoRunnable = player.length;
                int n = 0;
                while (n < intoRunnable) {
                    String server = player[n];
                    ServerInfo serverMotd = ProxyServer.getInstance().getServerInfo(server);
                    if (serverMotd != null) {
                        motds.add(serverMotd.getMotd());
                    }
                    ++n;
                }
                return motds;
            }
            case PLAYERDISPLAYNAME: {
                if (players.isEmpty()) break;
                HashSet<String> names = new HashSet<String>();
                for (ProxiedPlayer player : players) {
                    names.add(player.getDisplayName());
                    if (packet.getObject() == null || packet.getChangeMode() == null) continue;
                    switch (packet.getChangeMode()) {
                        case ADD: 
                        case SET: {
                            player.setDisplayName((String)packet.getObject());
                            break;
                        }
                        case REMOVE: 
                        case REMOVE_ALL: 
                        case DELETE: 
                        case RESET: {
                            player.setDisplayName((String)packet.getObject());
                        }
                    }
                }
                return names;
            }
            case MAXPLAYERS: {
                if (packet.getObject() == null) break;
                HashSet<Integer> limits = new HashSet<Integer>();
                String[] player = (String[])packet.getObject();
                int intoRunnable = player.length;
                int n = 0;
                while (n < intoRunnable) {
                    String server = player[n];
                    ConnectedServer[] connectedServerArray = ServerTracker.get(server);
                    int n4 = connectedServerArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        ConnectedServer serverMax = connectedServerArray[n5];
                        if (serverMax != null && ServerTracker.isResponding(serverMax).booleanValue()) {
                            limits.add(serverMax.getMaxPlayers());
                        }
                        ++n5;
                    }
                    ++n;
                }
                return limits;
            }
            case EVALUATE: {
                if (packet.getObject() == null || packet.getSetObject() == null) {
                    return null;
                }
                String[] evaluations = (String[])packet.getObject();
                String[] evalServers = (String[])packet.getSetObject();
                BungeePacket evalPacket = new BungeePacket((Boolean)false, BungeePacketType.EVALUATE, evaluations);
                String[] stringArray = evalServers;
                int serverMax = evalServers.length;
                int player = 0;
                while (player < serverMax) {
                    String server = stringArray[player];
                    BungeeSockets.send(evalPacket, ServerTracker.get(server));
                    ++player;
                }
                break;
            }
            case ISSERVERONLINE: {
                if (packet.getObject() != null) {
                    if (packet.getObject() instanceof String) {
                        ConnectedServer[] checkServers = ServerTracker.get((String)packet.getObject());
                        if (checkServers != null && ServerTracker.isResponding(checkServers[0]).booleanValue()) {
                            return true;
                        }
                        return false;
                    }
                    ArrayList<Boolean> list = new ArrayList<Boolean>();
                    String[] array = (String[])packet.getObject();
                    int i = 0;
                    while (i < array.length) {
                        ConnectedServer[] checkServers = ServerTracker.get(array[i]);
                        list.add(checkServers != null && ServerTracker.isResponding(checkServers[0]) != false);
                        ++i;
                    }
                    return list.isEmpty() ? null : list;
                }
                return false;
            }
            case WHITELISTED: {
                if (packet.getObject() == null) break;
                HashSet<SkungeePlayer> whitelistedPlayers = new HashSet<SkungeePlayer>();
                String[] stringArray = (String[])packet.getObject();
                int checkServers = stringArray.length;
                int i = 0;
                while (i < checkServers) {
                    String server = stringArray[i];
                    ConnectedServer[] connectedServerArray = ServerTracker.get(server);
                    int n = connectedServerArray.length;
                    int n6 = 0;
                    while (n6 < n) {
                        ConnectedServer serverWhitelisted = connectedServerArray[n6];
                        if (serverWhitelisted != null && ServerTracker.isResponding(serverWhitelisted).booleanValue()) {
                            whitelistedPlayers.addAll(serverWhitelisted.getWhitelistedPlayers());
                        }
                        ++n6;
                    }
                    ++i;
                }
                return whitelistedPlayers;
            }
            case NETWORKVARIABLE: {
                break;
            }
            case PLAYERCHATMODE: {
                if (players.isEmpty()) break;
                HashSet<SkungeeEnums.ChatMode> modes = new HashSet<SkungeeEnums.ChatMode>();
                for (ProxiedPlayer player : players) {
                    SkungeeEnums.ChatMode chatmode = Utils.getEnum(SkungeeEnums.ChatMode.class, player.getChatMode().toString());
                    if (chatmode == null) continue;
                    modes.add(chatmode);
                }
                return modes;
            }
            case PLAYERHANDSETTING: {
                if (players.isEmpty()) break;
                HashSet<SkungeeEnums.HandSetting> settings = new HashSet<SkungeeEnums.HandSetting>();
                for (ProxiedPlayer player : players) {
                    SkungeeEnums.HandSetting chatmode = Utils.getEnum(SkungeeEnums.HandSetting.class, player.getMainHand().toString());
                    if (chatmode == null) continue;
                    settings.add(chatmode);
                }
                return settings;
            }
            case PLAYERRECONNECTSERVER: {
                if (players.isEmpty()) break;
                HashSet<String> reconnected = new HashSet<String>();
                for (ProxiedPlayer player : players) {
                    reconnected.add(player.getReconnectServer().getName());
                    if (packet.getObject() == null || packet.getChangeMode() == null || packet.getChangeMode() != SkungeeEnums.SkriptChangeMode.SET) continue;
                    player.setReconnectServer(ProxyServer.getInstance().getServerInfo((String)packet.getObject()));
                }
                return reconnected;
            }
            case PLAYERHASPERMISSIONS: {
                if (packet.getObject() != null && players != null) {
                    if (players.isEmpty()) {
                        return false;
                    }
                    String[] chatmode = (String[])packet.getObject();
                    int i = chatmode.length;
                    int player = 0;
                    while (player < i) {
                        String permission = chatmode[player];
                        if (!((ProxiedPlayer)players.get(0)).hasPermission(permission)) {
                            return false;
                        }
                        ++player;
                    }
                } else {
                    return false;
                }
                return true;
            }
            case PLAYERCOMMAND: {
                HashSet<Boolean> registered = new HashSet<Boolean>();
                if (!players.isEmpty() && packet.getObject() != null) {
                    for (ProxiedPlayer player : players) {
                        String[] stringArray = (String[])packet.getObject();
                        int serverWhitelisted = stringArray.length;
                        int n = 0;
                        while (n < serverWhitelisted) {
                            String command = stringArray[n];
                            registered.add(ProxyServer.getInstance().getPluginManager().dispatchCommand((CommandSender)player, command));
                            ++n;
                        }
                    }
                }
                return registered != null && !registered.isEmpty() ? registered : null;
            }
            case REDISPLAYERS: {
                HashSet<SkungeePlayer> redisPlayers = new HashSet<SkungeePlayer>();
                for (UUID uuid : RedisBungee.getApi().getPlayersOnline()) {
                    redisPlayers.add(new SkungeePlayer(false, uuid, ProxyServer.getInstance().getPlayer(uuid).getName()));
                }
                return redisPlayers != null && !redisPlayers.isEmpty() ? redisPlayers : null;
            }
            case REDISPROXYPLAYERS: {
                if (packet.getObject() == null) {
                    return null;
                }
                HashSet<SkungeePlayer> proxyPlayers = new HashSet<SkungeePlayer>();
                String[] stringArray = (String[])packet.getObject();
                int serverWhitelisted = stringArray.length;
                int n = 0;
                while (n < serverWhitelisted) {
                    String server = stringArray[n];
                    for (UUID uuid : RedisBungee.getApi().getPlayersOnProxy(server)) {
                        proxyPlayers.add(new SkungeePlayer(false, uuid, ProxyServer.getInstance().getPlayer(uuid).getName()));
                    }
                    ++n;
                }
                return proxyPlayers != null && !proxyPlayers.isEmpty() ? proxyPlayers : null;
            }
            case REDISSERVERPLAYERS: {
                if (packet.getObject() == null) {
                    return null;
                }
                HashSet<SkungeePlayer> serverPlayers = new HashSet<SkungeePlayer>();
                String[] uuid = (String[])packet.getObject();
                int n = uuid.length;
                int serverWhitelisted = 0;
                while (serverWhitelisted < n) {
                    String server = uuid[serverWhitelisted];
                    for (UUID uuid2 : RedisBungee.getApi().getPlayersOnServer(server)) {
                        serverPlayers.add(new SkungeePlayer(false, uuid2, ProxyServer.getInstance().getPlayer(uuid2).getName()));
                    }
                    ++serverWhitelisted;
                }
                return serverPlayers != null && !serverPlayers.isEmpty() ? serverPlayers : null;
            }
            case REDISPROXYCOMMAND: {
                if (packet.getObject() == null) {
                    return null;
                }
                String[] uuid = (String[])packet.getObject();
                int n = uuid.length;
                int serverWhitelisted = 0;
                while (serverWhitelisted < n) {
                    String command = uuid[serverWhitelisted];
                    if (packet.getSetObject() != null) {
                        String[] stringArray = (String[])packet.getSetObject();
                        int n7 = stringArray.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            String server = stringArray[n8];
                            RedisBungee.getApi().sendProxyCommand(server, command);
                            ++n8;
                        }
                    } else {
                        RedisBungee.getApi().sendProxyCommand(command);
                    }
                    ++serverWhitelisted;
                }
                break;
            }
            case REDISPLAYERNAME: {
                if (packet.getObject() == null || players.isEmpty()) {
                    return null;
                }
                HashSet<SkungeePlayer> names = new HashSet<SkungeePlayer>();
                for (ProxiedPlayer player : players) {
                    names.add(new SkungeePlayer(false, player.getUniqueId(), RedisBungee.getApi().getNameFromUuid(player.getUniqueId(), true)));
                }
                return names != null && !names.isEmpty() ? names : null;
            }
            case REDISISPLAYERONLINE: {
                if (players.isEmpty()) {
                    return false;
                }
                if (players != null && RedisBungee.getApi().isPlayerOnline(((ProxiedPlayer)players.get(0)).getUniqueId())) {
                    return true;
                }
                return false;
            }
            case REDISLASTLOGIN: {
                if (packet.getObject() == null || players.isEmpty()) {
                    return null;
                }
                HashSet<Long> logins = new HashSet<Long>();
                for (ProxiedPlayer player : players) {
                    logins.add(RedisBungee.getApi().getLastOnline(player.getUniqueId()));
                }
                return logins != null && !logins.isEmpty() ? logins : null;
            }
            case REDISPLAYERID: {
                if (packet.getObject() == null || players.isEmpty()) {
                    return null;
                }
                HashSet<String> IDS = new HashSet<String>();
                for (ProxiedPlayer player : players) {
                    IDS.add(RedisBungee.getApi().getProxy(player.getUniqueId()));
                }
                return IDS != null && !IDS.isEmpty() ? IDS : null;
            }
            case REDISPLAYERSERVER: {
                if (packet.getObject() == null || players.isEmpty()) {
                    return null;
                }
                HashSet<String> redisservers = new HashSet<String>();
                for (ProxiedPlayer player : players) {
                    redisservers.add(RedisBungee.getApi().getServerFor(player.getUniqueId()).getName());
                }
                return redisservers != null && !redisservers.isEmpty() ? redisservers : null;
            }
            case REDISPLAYERIP: {
                if (packet.getObject() == null || players.isEmpty()) {
                    return null;
                }
                HashSet<String> IPS = new HashSet<String>();
                for (ProxiedPlayer player : players) {
                    IPS.add(RedisBungee.getApi().getPlayerIp(player.getUniqueId()).getHostName());
                }
                return IPS != null && !IPS.isEmpty() ? IPS : null;
            }
            case ISPLAYERONLINE: {
                if (players.isEmpty()) {
                    return false;
                }
                if (players != null && ((ProxiedPlayer)players.get(0)).isConnected()) {
                    return true;
                }
                return false;
            }
            case ISUSINGFORGE: {
                if (players.isEmpty()) {
                    return false;
                }
                if (players != null && ((ProxiedPlayer)players.get(0)).isForgeUser()) {
                    return true;
                }
                return false;
            }
            case PLAYERCOLOURS: {
                if (players.isEmpty()) {
                    return false;
                }
                if (players != null && ((ProxiedPlayer)players.get(0)).hasChatColors()) {
                    return true;
                }
                return false;
            }
            case DISCONNECT: {
                if (packet.getObject() == null) break;
                ServerTracker.notResponding(ServerTracker.getByAddress(address, (Integer)packet.getObject()));
                break;
            }
            case CREATESERVER: {
                if (packet.getObject() == null || packet.getSetObject() == null) break;
                ServerInstancesSockets.send(new ServerInstancesPacket(false, ServerInstancesPacketType.CREATESERVER, packet.getObject(), packet.getSetObject()));
                break;
            }
            case SKUNGEEMESSAGES: {
                if (packet.getObject() == null || packet.getSetObject() == null) {
                    return null;
                }
                String[] messages = (String[])packet.getObject();
                String[] channels = (String[])packet.getSetObject();
                BungeeSockets.sendAll(new BungeePacket((Boolean)false, BungeePacketType.SKUNGEEMESSAGES, (Object)messages, channels));
                break;
            }
            case TABHEADERFOOTER: {
                if (players.isEmpty() || packet.getObject() == null) break;
                TextComponent component = new TextComponent();
                String[] stringArray = (String[])packet.getObject();
                int n = stringArray.length;
                int n9 = 0;
                while (n9 < n) {
                    String text = stringArray[n9];
                    component.addExtra(text);
                    ++n9;
                }
                for (ProxiedPlayer player : players) {
                    if (player == null) continue;
                    if (packet.getSetObject() instanceof Integer) {
                        int pattern = (Integer)packet.getSetObject();
                        if (pattern == 1) {
                            player.setTabHeader((BaseComponent)component, (BaseComponent)new TextComponent());
                            continue;
                        }
                        if (pattern == 2) {
                            player.setTabHeader((BaseComponent)new TextComponent(), (BaseComponent)component);
                            continue;
                        }
                        player.setTabHeader((BaseComponent)component, (BaseComponent)component);
                        continue;
                    }
                    TextComponent secondary = new TextComponent();
                    String[] stringArray2 = (String[])packet.getSetObject();
                    int n10 = stringArray2.length;
                    int n11 = 0;
                    while (n11 < n10) {
                        String text = stringArray2[n11];
                        secondary.addExtra(text);
                        ++n11;
                    }
                    player.setTabHeader((BaseComponent)component, (BaseComponent)secondary);
                }
                break;
            }
            case PLAYERPERMISSIONS: {
                if (players.isEmpty()) break;
                if (packet.getObject() != null && packet.getChangeMode() != null) {
                    HashSet<String> permissions = new HashSet<String>();
                    Object[] text = (Object[])packet.getObject();
                    int secondary = text.length;
                    int n = 0;
                    while (n < secondary) {
                        Object object = text[n];
                        if (object instanceof String) {
                            permissions.add((String)object);
                        }
                        ++n;
                    }
                    block114: for (ProxiedPlayer player : players) {
                        switch (packet.getChangeMode()) {
                            case SET: {
                                for (String permission : player.getPermissions()) {
                                    player.setPermission(permission, false);
                                }
                            }
                            case ADD: {
                                for (String permission : permissions) {
                                    player.setPermission(permission, true);
                                }
                                continue block114;
                            }
                            case DELETE: 
                            case RESET: {
                                for (String permission : player.getPermissions()) {
                                    player.setPermission(permission, false);
                                }
                                continue block114;
                            }
                            case REMOVE: 
                            case REMOVE_ALL: {
                                for (String permission : permissions) {
                                    player.setPermission(permission, false);
                                }
                                continue block114;
                            }
                        }
                    }
                    break;
                }
                HashSet permissions = new HashSet();
                for (ProxiedPlayer player : players) {
                    permissions.addAll(player.getPermissions());
                }
                return permissions;
            }
            case PLAYERGROUPS: {
                if (players.isEmpty()) break;
                if (packet.getObject() != null && packet.getChangeMode() != null) {
                    String[] groups = new String[((Object[])packet.getObject()).length];
                    int i = 0;
                    Object[] objectArray = (Object[])packet.getObject();
                    int text = objectArray.length;
                    int n = 0;
                    while (n < text) {
                        Object object = objectArray[n];
                        if (object instanceof String) {
                            groups[i] = (String)object;
                        }
                        ++n;
                    }
                    for (ProxiedPlayer player : players) {
                        Collection playerGroups = player.getGroups();
                        switch (packet.getChangeMode()) {
                            case SET: {
                                player.removeGroups(playerGroups.toArray(new String[playerGroups.size()]));
                            }
                            case ADD: {
                                player.addGroups(groups);
                                break;
                            }
                            case DELETE: 
                            case RESET: {
                                player.removeGroups(playerGroups.toArray(new String[playerGroups.size()]));
                                break;
                            }
                            case REMOVE: 
                            case REMOVE_ALL: {
                                player.removeGroups(groups);
                            }
                        }
                    }
                    break;
                }
                HashSet groups = new HashSet();
                for (ProxiedPlayer player2 : players) {
                    groups.addAll(player2.getGroups());
                }
                return groups;
            }
            case UNREGISTERCOMMANDS: {
                if (packet.getObject() == null) break;
                String[] stringArray = (String[])packet.getObject();
                int player = stringArray.length;
                int player2 = 0;
                while (player2 < player) {
                    String name = stringArray[player2];
                    PluginManager manager = ProxyServer.getInstance().getPluginManager();
                    Plugin plugin = manager.getPlugin(name);
                    if (plugin != null && !name.equalsIgnoreCase("skungee")) {
                        manager.unregisterCommands(plugin);
                    }
                    ++player2;
                }
                break;
            }
            case UNREGISTERLISTENERS: {
                if (packet.getObject() == null) break;
                String[] stringArray = (String[])packet.getObject();
                int player = stringArray.length;
                int player2 = 0;
                while (player2 < player) {
                    String name = stringArray[player2];
                    PluginManager manager = ProxyServer.getInstance().getPluginManager();
                    Plugin plugin = manager.getPlugin(name);
                    if (plugin != null && !name.equalsIgnoreCase("skungee")) {
                        manager.unregisterListeners(plugin);
                    }
                    ++player2;
                }
                break;
            }
            case SHUTDOWNSERVER: {
                if (packet.getObject() == null) break;
                ServerInstancesPacket unload = new ServerInstancesPacket(false, ServerInstancesPacketType.SHUTDOWN, (String[])packet.getObject());
                if (packet.getSetObject() != null) {
                    unload = new ServerInstancesPacket(false, ServerInstancesPacketType.SHUTDOWN, packet.getObject(), packet.getSetObject());
                }
                ServerInstancesSockets.send(unload);
                BungeePacket shutdown = new BungeePacket((Boolean)false, BungeePacketType.SHUTDOWN, new SkungeePlayer[0]);
                String[] stringArray = (String[])packet.getObject();
                int n = stringArray.length;
                int n12 = 0;
                while (n12 < n) {
                    String server = stringArray[n12];
                    BungeeSockets.send(shutdown, ServerTracker.get(server));
                    ++n12;
                }
                break;
            }
            case ENABLEPLUGINS: {
                ProxyServer.getInstance().getPluginManager().enablePlugins();
                break;
            }
            case SERVERINSTANCES: {
                return ServerInstancesSockets.send(new ServerInstancesPacket(true, ServerInstancesPacketType.SERVERINSTANCES));
            }
            case LOADPLUGINS: {
                ProxyServer.getInstance().getPluginManager().loadPlugins();
                break;
            }
            case REDISSERVERS: {
                return RedisBungee.getApi().getAllServers();
            }
            case REDISSERVERID: {
                return RedisBungee.getApi().getServerId();
            }
            case BUNGEEVERSION: {
                return ProxyServer.getInstance().getVersion();
            }
            case CURRENTSERVER: {
                return ServerTracker.getByAddress(address, (Integer)packet.getObject()) != null ? ServerTracker.getByAddress(address, (Integer)packet.getObject()).getName() : null;
            }
            case DISABLEDCOMMANDS: {
                return ProxyServer.getInstance().getDisabledCommands();
            }
            case BUNGEENAME: {
                return ProxyServer.getInstance().getName();
            }
            case PLUGINS: {
                return ProxyServer.getInstance().getPluginManager().getPlugins();
            }
            case BUNGEEPLAYERLIMIT: {
                return ProxyServer.getInstance().getConfig().getPlayerLimit();
            }
            case BUNGEETHROTTLE: {
                return ProxyServer.getInstance().getConfig().getThrottle();
            }
            case BUNGEETIMEOUT: {
                return ProxyServer.getInstance().getConfig().getTimeout();
            }
            case BUNGEEONLINEMODE: {
                return ProxyServer.getInstance().getConfig().isOnlineMode();
            }
        }
        return null;
    }
}

