/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.variables;

import com.google.common.collect.Sets;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.limeglass.skungee.bungeecord.Skungee;
import me.limeglass.skungee.bungeecord.sockets.BungeeSockets;
import me.limeglass.skungee.bungeecord.sockets.ServerTracker;
import me.limeglass.skungee.bungeecord.variables.SkungeeStorage;
import me.limeglass.skungee.objects.SkungeeVariable;
import me.limeglass.skungee.objects.packets.BungeePacket;
import me.limeglass.skungee.objects.packets.BungeePacketType;

public class FlatFileStorage
extends SkungeeStorage {
    private final String DELIMITER = "@: ";
    private boolean loadingHash = false;
    private File folder;
    private File file;
    private FileWriter writer;
    private Gson gson;

    static {
        FlatFileStorage.registerStorage(new FlatFileStorage());
    }

    public FlatFileStorage() {
        super("CSV", "flatfile");
    }

    private void header() throws IOException {
        this.writer.append("\n");
        this.writer.append("# Skungee's variable database.");
        this.writer.append("\n");
        this.writer.append("# Please do not modify this file manually, thank you!");
        this.writer.append("\n");
        this.writer.append("\n");
    }

    @Override
    public boolean initialize() {
        this.gson = new GsonBuilder().setLenient().setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).create();
        this.file = new File(String.valueOf(variablesFolder) + "variables.csv");
        this.folder = new File(variablesFolder);
        this.folder.mkdir();
        if (!this.file.exists()) {
            try {
                this.writer = new FileWriter(this.file);
                this.header();
                this.writer.flush();
                Skungee.debugMessage("Successfully created CSV variables database!");
            }
            catch (IOException e) {
                Skungee.exception(e, "Failed to create a CSV variable database.");
                return false;
            }
        } else {
            this.load();
        }
        return true;
    }

    @Override
    public SkungeeVariable.Value[] get(String index) {
        if (index.endsWith("::*")) {
            HashSet<SkungeeVariable.Value> values = new HashSet<SkungeeVariable.Value>();
            String varIndex = index.substring(0, index.length() - 3);
            for (Map.Entry entry : variables.entrySet()) {
                SkungeeVariable.Value[] data;
                if (!((String)entry.getKey()).startsWith(varIndex) || (data = (SkungeeVariable.Value[])variables.get(entry.getKey())) == null) continue;
                SkungeeVariable.Value[] valueArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    SkungeeVariable.Value value = valueArray[n2];
                    values.add(value);
                    ++n2;
                }
            }
            SkungeeVariable.Value[] data = (SkungeeVariable.Value[])variables.get(index);
            if (data != null) {
                SkungeeVariable.Value[] valueArray = data;
                int n = data.length;
                int n3 = 0;
                while (n3 < n) {
                    SkungeeVariable.Value value = valueArray[n3];
                    values.add(value);
                    ++n3;
                }
            }
            return values.toArray(new SkungeeVariable.Value[values.size()]);
        }
        return (SkungeeVariable.Value[])variables.get(index);
    }

    @Override
    public void remove(String ... indexes) {
        HashSet indexSet = Sets.newHashSet((Object[])indexes);
        String[] stringArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            String index = stringArray[n2];
            if (index.endsWith("::*")) {
                String varIndex = index.substring(0, index.length() - 3);
                for (Map.Entry entry : variables.entrySet()) {
                    if (!((String)entry.getKey()).startsWith(varIndex)) continue;
                    indexSet.add((String)entry.getKey());
                }
            }
            ++n2;
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            Skungee.exception(e, "Failed to close writer for removing index");
        }
        for (String index : indexSet) {
            if (!variables.containsKey(index) || this.loadingHash) continue;
            variables.remove(index);
        }
        this.loadFromHash();
    }

    @Override
    public void backup() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            Skungee.exception(e, "Error closing the variable flatfile writter");
        }
        Date date = new Date();
        new File(this.folder + File.separator + "backups" + File.separator).mkdir();
        File newFile = new File(this.folder + File.separator + "backups" + File.separator + date.toString().replaceAll(":", "-") + ".csv");
        try {
            Files.copy(this.file.toPath(), newFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            Skungee.exception(e, "Failed to backup flatfile");
        }
        this.load();
    }

    private void load() {
        String line = "";
        BufferedReader reader = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            reader = new BufferedReader(new FileReader(this.file));
            int i = 0;
            while (i < 4) {
                reader.readLine();
                ++i;
            }
            while ((line = reader.readLine()) != null) {
                String[] values = line.split("@: ", 2);
                if (values.length != 2) continue;
                map.put(values[0], values[1]);
            }
            this.writer = new FileWriter(this.file);
            this.header();
            for (Map.Entry data : map.entrySet()) {
                SkungeeVariable.Value[] values = (SkungeeVariable.Value[])this.gson.fromJson((String)data.getValue(), SkungeeVariable.Value[].class);
                this.set((String)data.getKey(), values);
            }
            reader.close();
        }
        catch (IOException e) {
            Skungee.exception(e, "Failed to load and write variables.");
        }
    }

    @Override
    public void set(String name, SkungeeVariable.Value[] values) {
        if (Skungee.getConfig().getBoolean("NetworkVariables.AutomaticSharing", false) && !ServerTracker.isEmpty().booleanValue()) {
            BungeeSockets.sendAll(new BungeePacket((Boolean)false, BungeePacketType.UPDATEVARIABLES, (Object)name, values));
        }
        if (variables.containsKey(name) && !this.loadingHash) {
            if (Skungee.getConfig().getBoolean("NetworkVariables.AllowOverrides", true)) {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    Skungee.exception(e, "Failed to close the writer while setting the value: " + name);
                }
                variables.remove(name);
                this.loadFromHash();
            } else {
                return;
            }
        }
        variables.put(name, values);
        try {
            try {
                this.writer.append(name);
                this.writer.append("@: ");
                this.writer.append(this.gson.toJson((Object)values));
                this.writer.append("\n");
            }
            catch (IOException e) {
                try {
                    this.writer = new FileWriter(this.file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.writer.flush();
                }
                catch (IOException e2) {
                    Skungee.debugMessage("Error flushing data while writing!");
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                Skungee.debugMessage("Error flushing data while writing!");
                e.printStackTrace();
            }
        }
    }

    private void loadFromHash() {
        block13: {
            this.loadingHash = true;
            try {
                try {
                    this.writer = new FileWriter(this.file);
                    this.header();
                    if (!variables.isEmpty()) {
                        Set ids = Sets.newConcurrentHashSet(variables.keySet());
                        for (String ID : ids) {
                            this.set(ID, (SkungeeVariable.Value[])variables.get(ID));
                        }
                    }
                }
                catch (IOException e) {
                    Skungee.exception(e, "Error flushing writer while loading from hash!");
                    try {
                        this.writer.flush();
                    }
                    catch (IOException e2) {
                        Skungee.exception(e2, "Error flushing writer while loading from hash!");
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.writer.flush();
                }
                catch (IOException e) {
                    Skungee.exception(e, "Error flushing writer while loading from hash!");
                }
                throw throwable;
            }
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                Skungee.exception(e, "Error flushing writer while loading from hash!");
            }
        }
        this.loadingHash = false;
    }
}

