/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import me.limeglass.skungee.EncryptionUtil;
import me.limeglass.skungee.UniversalSkungee;
import me.limeglass.skungee.bungeecord.BungecordMetrics;
import me.limeglass.skungee.bungeecord.VariableStorage;
import me.limeglass.skungee.bungeecord.handler.SkungeeHandler;
import me.limeglass.skungee.bungeecord.listeners.EventListener;
import me.limeglass.skungee.bungeecord.serverinstances.Premium;
import me.limeglass.skungee.bungeecord.sockets.ServerInstancesSockets;
import me.limeglass.skungee.bungeecord.variables.VariableManager;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginDescription;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class Skungee
extends Plugin {
    private static Map<String, Configuration> files = new HashMap<String, Configuration>();
    private static final String prefix = "&8[&cSkungee&8] &e";
    private static final String nameplate = "[Skungee] ";
    private static EncryptionUtil encryption;
    private static BungecordMetrics metrics;
    private ServerSocket serverSocket;
    private static Skungee instance;
    private File SCRIPTS_FOLDER;

    public void onEnable() {
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        UniversalSkungee.setBungeecord(true);
        this.SCRIPTS_FOLDER = new File(this.getDataFolder(), File.separator + "scripts");
        if (!this.SCRIPTS_FOLDER.exists()) {
            this.SCRIPTS_FOLDER.mkdir();
        }
        this.loadConfiguration();
        Premium.check();
        encryption = new EncryptionUtil(this, (Boolean)false);
        encryption.hashFile();
        SkungeeHandler.load();
        metrics = new BungecordMetrics(this);
        metrics.addCustomChart(new BungecordMetrics.MultiLineChart("amount_of_plugins"){

            @Override
            public HashMap<String, Integer> getValues(HashMap<String, Integer> map) {
                map.put("amount of variables", VariableManager.getMainStorage().getSize());
                map.put("amount of global scripts", Skungee.this.SCRIPTS_FOLDER.listFiles().length);
                return map;
            }
        });
        metrics.addCustomChart(new BungecordMetrics.SimplePie("amount_of_network_variables"){

            @Override
            public String getValue() {
                return String.valueOf(Skungee.this.getProxy().getPluginManager().getPlugins().size());
            }
        });
        metrics.addCustomChart(new BungecordMetrics.SimplePie("amount_of_global_scripts"){

            @Override
            public String getValue() {
                return VariableManager.getMainStorage().getNames()[0];
            }
        });
        if (Skungee.getConfig().getBoolean("Events", false)) {
            this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new EventListener());
        }
        VariableStorage.setup();
        this.connect();
        if (!Skungee.getConfig().getBoolean("DisableRegisteredInfo", false)) {
            Skungee.consoleMessage("has been enabled!");
        }
    }

    public void onDisable() {
        ServerInstancesSockets.shutdown();
    }

    private void loadConfiguration() {
        File config = new File(Skungee.getInstance().getDataFolder(), "config.yml");
        try (InputStream in = this.getResourceAsStream("Bungeecord/config.yml");){
            if (!config.exists()) {
                Files.copy(in, config.toPath(), new CopyOption[0]);
            }
            Configuration configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(config);
            if (!this.getDescription().getVersion().equals(configuration.getString("version"))) {
                Files.delete(config.toPath());
                this.loadConfiguration();
                Skungee.consoleMessage("&eThere is a new Skungee version. Generating new config...");
                return;
            }
            Skungee.addConfiguration("config", configuration);
        }
        catch (IOException e) {
            Skungee.exception(e, "Could not create and save serverinstances due to new configuration.");
        }
    }

    private void connect() {
        try {
            this.serverSocket = new ServerSocket(Skungee.getConfig().getInt("port", 1337), 69);
            Skungee.consoleMessage("connection established on port " + Skungee.getConfig().getInt("port", 1337));
            ProxyServer.getInstance().getScheduler().runAsync((Plugin)Skungee.getInstance(), (Runnable)((Object)new BungecordMetrics.SimplePie(this){

                @Override
                public String getValue() {
                    return "" + Premium.check();
                }
            }));
        }
        catch (IOException e) {
            Skungee.exception(e, "ServerSocket couldn't be created on port: " + Skungee.getConfig().getInt("port", 1337));
        }
    }

    public static final void exception(Throwable cause, String ... info) {
        HashMap<String, PluginDescription> plugins = new HashMap<String, PluginDescription>();
        for (StackTraceElement[] plugin : ProxyServer.getInstance().getPluginManager().getPlugins()) {
            if (plugin.getDescription().getName().equals("Skungee")) continue;
            String[] parts = plugin.getDescription().getMain().split("\\.");
            StringBuilder name = new StringBuilder(plugin.getDescription().getMain().length());
            for (int i = 0; i < parts.length - 1; ++i) {
                name.append(parts[i]).append('.');
            }
            plugins.put(name.toString(), plugin.getDescription());
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage(Skungee.getNameplate() + "Severe Error: " + Arrays.toString(info));
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Something went wrong within Skungee.");
        Skungee.infoMessage("Please report this error to the developers of Skungee so we can fix this from happening in the future.");
        HashSet stackPlugins = new HashSet();
        for (StackTraceElement stackTrace : Thread.currentThread().getStackTrace()) {
            for (Map.Entry entry : plugins.entrySet()) {
                if (!stackTrace.getClassName().contains((CharSequence)entry.getKey())) continue;
                stackPlugins.add(entry.getValue());
            }
        }
        if (!stackPlugins.isEmpty()) {
            Skungee.infoMessage(new String[0]);
            Skungee.infoMessage("It looks like you are using some plugin(s) that aren't allowing Skungee to work properly.");
            Skungee.infoMessage("Following plugins are probably related to this error in some way:");
            StringBuilder pluginsMessage = new StringBuilder();
            for (PluginDescription desc : stackPlugins) {
                pluginsMessage.append(desc.getName());
                pluginsMessage.append(" ");
            }
            Skungee.infoMessage(pluginsMessage.toString());
            Skungee.infoMessage("You should try disabling those plugins one by one, trying to find which one causes it.");
            Skungee.infoMessage("If the error doesn't disappear even after disabling all listed plugins, it is probably a Skungee issue.");
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Report this on the Skungee discussion page on SkUnity or Spigot. You can also message one of the Skungee developers.");
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Stack trace:");
        boolean first = true;
        while (cause != null) {
            Skungee.infoMessage((first ? "" : "Caused by: ") + cause.toString());
            for (StackTraceElement e : cause.getStackTrace()) {
                Skungee.infoMessage("    at " + e.toString());
            }
            cause = cause.getCause();
            first = false;
        }
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Information:");
        Skungee.infoMessage("  Skungee: " + Skungee.getConfig().getString("version"));
        Skungee.infoMessage("  Bungee: " + ProxyServer.getInstance().getVersion());
        Skungee.infoMessage("  Game version: " + ProxyServer.getInstance().getGameVersion());
        Skungee.infoMessage("  Protocol version: " + ProxyServer.getInstance().getProtocolVersion());
        Skungee.infoMessage("  Java: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + ")");
        Skungee.infoMessage("  OS: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version"));
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("Thread: " + Thread.currentThread());
        Skungee.infoMessage("Cause: " + Arrays.toString(info));
        Skungee.infoMessage(new String[0]);
        Skungee.infoMessage("End of Error.");
        Skungee.infoMessage(new String[0]);
    }

    public static Skungee getInstance() {
        return instance;
    }

    public static Configuration getConfig() {
        return Skungee.getConfiguration("config");
    }

    public static BungecordMetrics getMetrics() {
        return metrics;
    }

    public static EncryptionUtil getEncrypter() {
        return encryption;
    }

    public static String getNameplate() {
        return nameplate;
    }

    public static String getPrefix() {
        return prefix;
    }

    public File getScriptsFolder() {
        return this.SCRIPTS_FOLDER;
    }

    public Map<String, Configuration> getFiles() {
        return files;
    }

    public static void addConfiguration(String name, Configuration configuration) {
        files.put(name, configuration);
    }

    public static void debugMessage(String text) {
        if (Skungee.getConfig().getBoolean("debug")) {
            Skungee.consoleMessage("&b" + text);
        }
    }

    public static Configuration getConfiguration(String file) {
        return files.containsKey(file) ? files.get(file) : null;
    }

    public static String cc(String string) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)string);
    }

    public static void infoMessage(String ... messages) {
        if (messages != null && messages.length > 0) {
            for (String text : messages) {
                ProxyServer.getInstance().getLogger().info(Skungee.getNameplate() + text);
            }
        } else {
            ProxyServer.getInstance().getLogger().info("");
        }
    }

    public static void consoleMessage(String ... messages) {
        if (Skungee.getConfig().getBoolean("DisableConsoleMessages", false)) {
            return;
        }
        if (messages != null && messages.length > 0) {
            for (String text : messages) {
                if (Skungee.getConfig().getBoolean("DisableConsoleColour", false)) {
                    Skungee.infoMessage(ChatColor.stripColor((String)Skungee.cc(text)));
                    continue;
                }
                ProxyServer.getInstance().getLogger().info(Skungee.cc(prefix + text));
            }
        } else {
            ProxyServer.getInstance().getLogger().info("");
        }
    }

    static /* synthetic */ File access$000(Skungee x0) {
        return x0.SCRIPTS_FOLDER;
    }

    static /* synthetic */ ServerSocket access$100(Skungee x0) {
        return x0.serverSocket;
    }
}

