/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.skungee.bungeecord.utils;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeeReflectionUtil {
    public static Set<Class<?>> getClasses(JarFile jar, String ... packages) {
        HashSet classes = new HashSet();
        try {
            Enumeration<JarEntry> jarEntry = jar.entries();
            while (jarEntry.hasMoreElements()) {
                String name = jarEntry.nextElement().getName().replace("/", ".");
                String className = name.substring(0, name.length() - 6);
                className = className.replace('/', '.');
                String[] stringArray = packages;
                int n = packages.length;
                int n2 = 0;
                while (n2 < n) {
                    String packageName = stringArray[n2];
                    if (name.startsWith(packageName) && name.endsWith(".class")) {
                        classes.add(Class.forName(className));
                    }
                    ++n2;
                }
            }
            jar.close();
        }
        catch (IOException | ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        return classes;
    }

    public static Set<Class<?>> getClasses(Plugin instance, String ... packages) {
        try {
            JarFile jar = new JarFile(instance.getFile());
            return BungeeReflectionUtil.getClasses(jar, packages);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> Set<Class<? extends T>> getSubTypesOf(Plugin instance, Class<T> of, String ... packages) {
        return BungeeReflectionUtil.getClasses(instance, packages).parallelStream().filter(clazz2 -> clazz2.isAssignableFrom(of)).map(clazz -> clazz).collect(Collectors.toSet());
    }
}

